'*********************************************************************
'** (c) 2018 Roku, Inc.  All content herein is protected by U.S.
'** copyright and other applicable intellectual property laws and may
'** not be copied without the express permission of Roku, Inc., which
'** reserves all rights.  Reuse of any of this content for any purpose
'** without the permission of Roku, Inc. is strictly prohibited.
'*********************************************************************
' Roku_MFG_State.brs
' Wrapper module to maintain the MFG state
Library "state/Roku_MFG_State_Store.brs"
Library "state/Roku_MFG_State_Tuner.brs"

function RokuMfgState() as Object
    g_ = getGlobalAA()
    if invalid = g_.mfg_state then
        o = {
            general: RokuMfgState_StoreModuleInit(),
            tuner: RokuMfgState_TunerModuleInit(),

            get: RokuMfgState_GeneralGet,
            set: RokuMfgState_GeneralSet
        }

        o.set("TestPatternPlane", "graphics")
        o.set("CurrentInputSource", "ui")
        o.set("LastInputSource", "ui")
        o.set("TVSignalState", "unknown")
        o.set("TVSignalMode", {})
        o.set("PQLayer", "persistent")

        g_.mfg_state = o
    end if

    return g_.mfg_state
end function

function RokuMfgState_GeneralSet(key as String, value as Dynamic) as Boolean
    return m.general.set(key, value)
end function

function RokuMfgState_GeneralGet(key as String) as Dynamic
    return m.general.get(key)
end function
