'*********************************************************************
'** (c) 2018-2019 Roku, Inc.  All content herein is protected by U.S.
'** copyright and other applicable intellectual property laws and may
'** not be copied without the express permission of Roku, Inc., which
'** reserves all rights.  Reuse of any of this content for any purpose
'** without the permission of Roku, Inc. is strictly prohibited.
'*********************************************************************
' Roku_MFG_Legacy.brs
' Legacy API Wrapper definitions
Library "legacy/Roku_Mfg_Legacy_AQ.brs"
Library "legacy/Roku_Mfg_Legacy_Barcode.brs"
Library "legacy/Roku_Mfg_Legacy_Base.brs"
Library "legacy/Roku_Mfg_Legacy_Common.brs"
Library "legacy/Roku_Mfg_Legacy_I2C.brs"
Library "legacy/Roku_Mfg_Legacy_Networking.brs"
Library "legacy/Roku_Mfg_Legacy_PQ.brs"
Library "legacy/Roku_Mfg_Legacy_Raw.brs"
Library "legacy/Roku_Mfg_Legacy_STB.brs"
Library "legacy/Roku_Mfg_Legacy_Tuner.brs"
Library "legacy/Roku_Mfg_Legacy_TV.brs"

function RokuMfgLegacyApis() as Object
    apis = {
        ' From legacy "aq.cpp"
        SaveAQSettings:                 RokuMfgLegacy_SaveAQSettings,
        GetAudioVolume:                 RokuMfgLegacy_GetAudioVolume,
        SetAudioVolume:                 RokuMfgLegacy_SetAudioVolume,
        EnableSetAudioVolume:           RokuMfgLegacy_EnableSetAudioVolume,
        SetAudioVolumeFade:             RokuMfgLegacy_SetAudioVolumeFade,
        GetAudioDelay:                  RokuMfgLegacy_GetAudioDelay,
        SetAudioDelay:                  RokuMfgLegacy_SetAudioDelay,
        GetAudioMute:                   RokuMfgLegacy_GetAudioMute,
        SetAudioMute:                   RokuMfgLegacy_SetAudioMute,
        GetAudioCurve:                  RokuMfgLegacy_GetAudioCurve,
        SetAudioCurve:                  RokuMfgLegacy_SetAudioCurve,
        GetAudioPrescalerGain:          RokuMfgLegacy_GetAudioPrescalerGain,
        SetAudioPrescalerGain:          RokuMfgLegacy_SetAudioPrescalerGain,
        GetAudioAmplifierGain:          RokuMfgLegacy_GetAudioAmplifierGain,
        SetAudioAmplifierGain:          RokuMfgLegacy_SetAudioAmplifierGain,
        GetAudioAmplifierRegister:      RokuMfgLegacy_GetAudioAmplifierRegister,
        SetAudioAmplifierRegister:      RokuMfgLegacy_SetAudioAmplifierRegister,
        GetAudioAmplifierEQBypass:      RokuMfgLegacy_GetAudioAmplifierEQBypass,
        SetAudioAmplifierEQBypass:      RokuMfgLegacy_SetAudioAmplifierEQBypass,
        GetAudioAmplifierDRCEnable:     RokuMfgLegacy_GetAudioAmplifierDRCEnable,
        SetAudioAmplifierDRCEnable:     RokuMfgLegacy_SetAudioAmplifierDRCEnable,
        GetAudioAmplifierParameters:    RokuMfgLegacy_GetAudioAmplifierParameters,
        SetAudioAmplifierParameters:    RokuMfgLegacy_SetAudioAmplifierParameters,
        GetAllAudioEQModes:             RokuMfgLegacy_GetAllAudioEQModes,
        GetAudioEQMode:                 RokuMfgLegacy_GetAudioEQMode,
        SetAudioEQMode:                 RokuMfgLegacy_SetAudioEQMode,
        GetAudioEQParameters:           RokuMfgLegacy_GetAudioEQParameters,
        SetAudioEQParameters:           RokuMfgLegacy_SetAudioEQParameters,
        GetAudioPEQEnabled:             RokuMfgLegacy_GetAudioPEQEnabled,
        EnableAudioPEQ:                 RokuMfgLegacy_EnableAudioPEQ,
        GetAudioSurroundModeEnabled:    RokuMfgLegacy_GetAudioSurroundModeEnabled,
        GetAudioSurroundBypassEnabled:  RokuMfgLegacy_GetAudioSurroundBypassEnabled,
        EnableAudioSurroundMode:        RokuMfgLegacy_EnableAudioSurroundMode,
        GetAudioDestinations:           RokuMfgLegacy_GetAudioDestinations,
        DoTFTPFetchSetSinglePtMicEQ:    RokuMfgLegacy_DoTFTPFetchSetSinglePtMicEQ,
        DoTFTPFetchSetMultiPtMicEQ:     RokuMfgLegacy_DoTFTPFetchSetMultiPtMicEQ,
        GetMicCompare:                  RokuMfgLegacy_GetMicCompare,
        StartAudioCapture:              RokuMfgLegacy_StartAudioCapture,
        EndAudioCapture:                RokuMfgLegacy_EndAudioCapture,
        SetAudioOutput:                 RokuMfgLegacy_SetAudioOutput,
        SetAudioInput:                  RokuMfgLegacy_SetAudioInput,
        SetDTSParameter:                RokuMfgLegacy_SetDTSParameter,
        GetDTSParameter:                RokuMfgLegacy_GetDTSParameter,
        GetDTSUnitEnable:               RokuMfgLegacy_GetDTSUnitEnable,
        SetDTSUnitEnable:               RokuMfgLegacy_SetDTSUnitEnable,
        SetTFTPAddress:                 RokuMfgLegacy_SetTFTPAddress,
        SetTFTPAudioName:               RokuMfgLegacy_SetTFTPAudioName,
        SetTFTPPath:                    RokuMfgLegacy_SetTFTPPath,
        DoTFTPFetchAudio:               RokuMfgLegacy_DoTFTPFetchAudio,
        DoInstallOOBEFromFile:          RokuMfgLegacy_DoInstallOOBEFromFile,
        DoInstallOOBE:                  RokuMfgLegacy_DoInstallOOBE,
        DoVerifyOOBE:                   RokuMfgLegacy_DoVerifyOOBE,
        DspOutCapture:                  RokuMfgLegacy_DspOutCapture,
        SetSpeakerGainCalibration:      RokuMfgLegacy_SetSpeakerGainCalibration,

        ' From legacy "barcode.cpp"
        GetBarcodeFile:                 RokuMfgLegacy_GetBarcodeFile,
        GetBarcodeFileFromString:       RokuMfgLegacy_GetBarcodeFileFromString,

        ' From legacy "base.cpp"
        GetMessagePort:                 RokuMfgLegacy_GetMessagePort,
        SetMessagePort:                 RokuMfgLegacy_SetMessagePort,

        ' From legacy "common.cpp"
        GetApiVersion:                  RokuMfgLegacy_GetApiVersion,
        GetApiBuildDate:                RokuMfgLegacy_GetApiBuildDate,
        GetChipType:                    RokuMfgLegacy_GetChipType,
        GetUnameString:                 RokuMfgLegacy_GetUnameString,
        GetTVSoftwareVersion:           RokuMfgLegacy_GetTVSoftwareVersion,
        GetComponentSoftwareVersion:    RokuMfgLegacy_GetComponentSoftwareVersion,
        GetSerialNumber:                RokuMfgLegacy_GetSerialNumber,
        GetLegacySerialNumber:          RokuMfgLegacy_GetLegacySerialNumber,
        GetAQPQVersion:                 RokuMfgLegacy_GetAQPQVersion,
        IsManufacturingMode:            RokuMfgLegacy_IsManufacturingMode,
        GetManufacturingYear:           RokuMfgLegacy_GetManufacturingYear,
        SetManufacturingYear:           RokuMfgLegacy_SetManufacturingYear,
        GetManufacturingMonth:          RokuMfgLegacy_GetManufacturingMonth,
        SetManufacturingMonth:          RokuMfgLegacy_SetManufacturingMonth,
        GetVendorDataVersions:          RokuMfgLegacy_GetVendorDataVersions,
        GetAutoStartMode:               RokuMfgLegacy_GetAutoStartMode,
        SetAutoStartMode:               RokuMfgLegacy_SetAutoStartMode,
        GetBackLitTime:                 RokuMfgLegacy_GetBackLitTime,
        ClearBackLitTime:               RokuMfgLegacy_ClearBackLitTime,
        RebootSystem:                   RokuMfgLegacy_RebootSystem,
        GoToStandby:                    RokuMfgLegacy_GoToStandby,
        GoToSuspend:                    RokuMfgLegacy_GoToSuspend,
        GetNextBootPartition:           RokuMfgLegacy_GetNextBootPartition,
        SetBootAlternatePartition:      RokuMfgLegacy_SetBootAlternatePartition,
        CalcPartitionCRC:               RokuMfgLegacy_CalcPartitionCRC,
        WriteTest:                      RokuMfgLegacy_WriteTest,
        FactoryFlipImage:               RokuMfgLegacy_FactoryFlipImage,
        FactoryNVMReset:                RokuMfgLegacy_FactoryNVMReset,
        FactoryShopInit:                RokuMfgLegacy_FactoryShopInit,
        ClearSettingsData:              RokuMfgLegacy_ClearSettingsData,
        GetCoreTemperature:             RokuMfgLegacy_GetCoreTemperature,
        GetChassisTemperature:          RokuMfgLegacy_GetChassisTemperature,
        SetLED:                         RokuMfgLegacy_SetLED,
        SetLED2:                        RokuMfgLegacy_SetLED2,
        Sync:                           RokuMfgLegacy_Sync,
        CECConnected:                   RokuMfgLegacy_CECConnected,
        GetDevMode:                     RokuMfgLegacy_GetDevMode,
        GetUSBDevices:                  RokuMfgLegacy_GetUSBDevices,
        SetPidOverride:                 RokuMfgLegacy_SetPidOverride,
        GetPidOverride:                 RokuMfgLegacy_GetPidOverride,
        ResetPcData:                    RokuMfgLegacy_ResetPcData,
        RescanCustomModel:              RokuMfgLegacy_RescanCustomModel,
        SetLEDFrame:                    RokuMfgLegacy_SetLEDFrame,
        StartLEDAnimation:              RokuMfgLegacy_StartLEDAnimation,
        StopLEDAnimation:               RokuMfgLegacy_StopLEDAnimation,
        SetCannedAnimation:             RokuMfgLegacy_SetCannedAnimation,
        DoButtonTestLatch:              RokuMfgLegacy_DoButtonTestLatch,
        DoButtonTestRE:                 RokuMfgLegacy_DoButtonTestRE,
        StartChild:                     RokuMfgLegacy_StartChild,
        SendChild:                      RokuMfgLegacy_SendChild,
        GetDeviceType:                  RokuMfgLegacy_GetDeviceType,
        GetBoardRevision:               RokuMfgLegacy_GetBoardRevision,
        EnableCpuBurn:                  RokuMfgLegacy_EnableCpuBurn,
        CpuBurnStatus:                  RokuMfgLegacy_CpuBurnStatus,
        GetSPDIFInputStatus:            RokuMfgLegacy_GetSPDIFInputStatus,

        ' From legacy "i2c.cpp"
        I2CRead:                        RokuMfgLegacy_I2CRead,
        I2CWrite:                       RokuMfgLegacy_I2CWrite,

        ' From legacy "networking.cpp"
        CheckNetworkStatus:             RokuMfgLegacy_CheckNetworkStatus,
        CheckEthLinkStatus:             RokuMfgLegacy_CheckEthLinkStatus,
        GetMacAddressString:            RokuMfgLegacy_GetMacAddressString,
        SetMacAddressString:            RokuMfgLegacy_SetMacAddressString,
        GetIpAddressString:             RokuMfgLegacy_GetIpAddressString,
        GetRouterIpAddressString:       RokuMfgLegacy_GetRouterIpAddressString,
        RenewIpAddress:                 RokuMfgLegacy_RenewIpAddress,
        DoPing:                         RokuMfgLegacy_DoPing,
        LoadWifiDriver:                 RokuMfgLegacy_LoadWifiDriver,
        CheckWifiDevice:                RokuMfgLegacy_CheckWifiDevice,
        CheckWifiStatus:                RokuMfgLegacy_CheckWifiStatus,
        GetWifiRssi:                    RokuMfgLegacy_GetWifiRssi,
        GetWifiStrength:                RokuMfgLegacy_GetWifiStrength,
        SetWifiDeviceStateOpen:         RokuMfgLegacy_SetWifiDeviceStateOpen,
        ConfigWifi:                     RokuMfgLegacy_ConfigWifi,
        DisableWifi:                    RokuMfgLegacy_DisableWifi,
        StartConfigWifi:                RokuMfgLegacy_StartConfigWifi,
        StartWifiReconnect:             RokuMfgLegacy_StartWifiReconnect,
        LoadBSAServer:                  RokuMfgLegacy_LoadBSAServer,
        StartCheckWifiDevicePresent:    RokuMfgLegacy_StartCheckWifiDevicePresent,
        UpdateWifiDevicePresent:        RokuMfgLegacy_UpdateWifiDevicePresent,
        StartCheckWifiStatus:           RokuMfgLegacy_StartCheckWifiStatus,
        UpdateWifiStatus:               RokuMfgLegacy_UpdateWifiStatus,
        SetBootWifi:                    RokuMfgLegacy_SetBootWifi,
        GetBootWifi:                    RokuMfgLegacy_GetBootWifi,
        ReadWifiEfuse:                  RokuMfgLegacy_ReadWifiEfuse,
        WriteWifiEfuse:                 RokuMfgLegacy_WriteWifiEfuse,
        ActivateBluetooth:              RokuMfgLegacy_ActivateBluetooth,

        ' From legacy "pq.cpp"
        SavePQOnExit:                   RokuMfgLegacy_SavePQOnExit,
        SavePQSettings:                 RokuMfgLegacy_SavePQSettings,
        SavePQDBChanges:                RokuMfgLegacy_SavePQDBChanges,
        GetPQDBEntry:                   RokuMfgLegacy_GetPQDBEntry,
        SetPQDBEntry:                   RokuMfgLegacy_SetPQDBEntry,
        ApplyPQUpdateEverywhere:        RokuMfgLegacy_ApplyPQUpdateEverywhere,
        ResetPQDBLayer:                 RokuMfgLegacy_ResetPQDBLayer,
        GetAllColorTemps:               RokuMfgLegacy_GetAllColorTemps,
        GetColorTemp:                   RokuMfgLegacy_GetColorTemp,
        SetColorTemp:                   RokuMfgLegacy_SetColorTemp,
        GetWhiteBalance:                RokuMfgLegacy_GetWhiteBalance,
        SetWhiteBalance:                RokuMfgLegacy_SetWhiteBalance,
        GetTempModeWhiteBalance:        RokuMfgLegacy_GetTempModeWhiteBalance,
        SetTempModeWhiteBalance:        RokuMfgLegacy_SetTempModeWhiteBalance,
        SetDefaultWhiteBalance:         RokuMfgLegacy_SetDefaultWhiteBalance,
        GetColorTempValues:             RokuMfgLegacy_GetColorTempValues,
        Get3DNR:                        RokuMfgLegacy_Get3DNR,
        Set3DNR:                        RokuMfgLegacy_Set3DNR,
        SwitchPictureMode:              RokuMfgLegacy_SwitchPictureMode,
        GetPicturePresetMode:           RokuMfgLegacy_GetPicturePresetMode,
        SetPicturePresetMode:           RokuMfgLegacy_SetPicturePresetMode,
        GetPictModeDisplayParameter:    RokuMfgLegacy_GetPictModeDisplayParameter,
        SetPictModeDisplayParameter:    RokuMfgLegacy_SetPictModeDisplayParameter,
        GetDisplayParameterValue:       RokuMfgLegacy_GetDisplayParameterValue,
        SetDisplayParameterValue:       RokuMfgLegacy_SetDisplayParameterValue,
        GetDisplayAspectRatio:          RokuMfgLegacy_GetDisplayAspectRatio,
        SetDisplayAspectRatio:          RokuMfgLegacy_SetDisplayAspectRatio,
        GetVideoCurve:                  RokuMfgLegacy_GetVideoCurve,
        SetVideoCurve:                  RokuMfgLegacy_SetVideoCurve,
        GetEditGlobalVideoPresets:      RokuMfgLegacy_GetEditGlobalVideoPresets,
        SetEditGlobalVideoPresets:      RokuMfgLegacy_SetEditGlobalVideoPresets,
        GetDynamicBacklightControl:     RokuMfgLegacy_GetDynamicBacklightControl,
        SetDynamicBacklightControl:     RokuMfgLegacy_SetDynamicBacklightControl,
        GetAllBacklightControls:        RokuMfgLegacy_GetAllBacklightControls,
        SetAllBacklightControls:        RokuMfgLegacy_SetAllBacklightControls,
        GetLocalDimmingControls:        RokuMfgLegacy_GetLocalDimmingControls,
        SetLocalDimmingControls:        RokuMfgLegacy_SetLocalDimmingControls,
        ForceGammaWBOnGraphics:         RokuMfgLegacy_ForceGammaWBOnGraphics,
        GetMixDimmingControls:          RokuMfgLegacy_GetMixDimmingControls,
        SetMixDimmingControls:          RokuMfgLegacy_SetMixDimmingControls,
        GetEPSAutoColorSpaceControls:   RokuMfgLegacy_GetEPSAutoColorSpaceControls,
        SetEPSAutoColorSpaceControls:   RokuMfgLegacy_SetEPSAutoColorSpaceControls,
        GetMEMCControls:                RokuMfgLegacy_GetMEMCControls,
        SetMEMCControls:                RokuMfgLegacy_SetMEMCControls,
        EnableDithering:                RokuMfgLegacy_EnableDithering,
        GetGammaTableData:              RokuMfgLegacy_GetGammaTableData,
        SetGammaTableData:              RokuMfgLegacy_SetGammaTableData,
        EnablePanelGamma:               RokuMfgLegacy_EnablePanelGamma,
        EnableGamma:                    RokuMfgLegacy_EnableGamma,
        EnablePreGainOffset:            RokuMfgLegacy_EnablePreGainOffset,
        SetPreGammaGainOffset:          RokuMfgLegacy_SetPreGammaGainOffset,
        GetDRMode:                      RokuMfgLegacy_GetDRMode,

        ' From legacy "raw.cpp"
        EnableRawKeys:                  RokuMfgLegacy_EnableRawKeys,
        DisableRawKeys:                 RokuMfgLegacy_DisableRawKeys,
        EnableKeyReleaseEvents:         RokuMfgLegacy_EnableKeyReleaseEvents,
        EnableRawKeyLedEvent:           RokuMfgLegacy_EnableRawKeyLedEvent,


        ' From legacy "stb.cpp"
        Supports4kHDMITX:               RokuMfgLegacy_Supports4kHDMITX,
        GetMonitorNameHDMITX:           RokuMfgLegacy_GetMonitorNameHDMITX,
        SetFan:                         RokuMfgLegacy_SetFan,
        GetFanRpm:                      RokuMfgLegacy_GetFanRpm,
        RunLitepointCmd:                RokuMfgLegacy_RunLitepointCmd,
        GetHardwareCapabilities:        RokuMfgLegacy_GetHardwareCapabilities,
        GetHdmiOutputMode:              RokuMfgLegacy_GetHdmiOutputMode,
        SetHdmiOutputMode:              RokuMfgLegacy_SetHdmiOutputMode,
        GetSinkEdid:                    RokuMfgLegacy_GetSinkEdid,

        ' From legacy "tuner.cpp"
        ClearChannels:                  RokuMfgLegacy_ClearChannels,
        GetChannelInfoByIndex:          RokuMfgLegacy_GetChannelInfoByIndex,
        GetIndexByChannelNumber:        RokuMfgLegacy_GetIndexByChannelNumber,
        TuneChannelByIndex:             RokuMfgLegacy_TuneChannelByIndex,
        ScanChannel:                    RokuMfgLegacy_ScanChannel,
        SetAnalogTVChannel:             RokuMfgLegacy_SetAnalogTVChannel,
        SetDigitalTVChannel:            RokuMfgLegacy_SetDigitalTVChannel,
        GetChannelIndex:                RokuMfgLegacy_GetChannelIndex,
        IncrementChannel:               RokuMfgLegacy_IncrementChannel,
        DecrementChannel:               RokuMfgLegacy_DecrementChannel,
        AddDtvChannel:                  RokuMfgLegacy_AddDtvChannel,
        LoadChannelListFile:            RokuMfgLegacy_LoadChannelListFile,
        SaveChannelListFile:            RokuMfgLegacy_SaveChannelListFile,
        GetClosedCaptioning:            RokuMfgLegacy_GetClosedCaptioning,
        SetClosedCaptioning:            RokuMfgLegacy_SetClosedCaptioning

        ' From legacy "tv.cpp"
        SyncInputOnAppExit:             RokuMfgLegacy_SyncInputOnAppExit,
        SetPanelType:                   RokuMfgLegacy_SetPanelType,
        GetPanelType:                   RokuMfgLegacy_GetPanelType,
        SetSpeakerType:                 RokuMfgLegacy_SetSpeakerType,
        GetSpeakerType:                 RokuMfgLegacy_GetSpeakerType,
        GetTvManufacturerId:            RokuMfgLegacy_GetTvManufacturerId,
        GetTvModel:                     RokuMfgLegacy_GetTvModel,
        SetTvModel:                     RokuMfgLegacy_SetTvModel,
        GetODMId:                       RokuMfgLegacy_GetODMId,
        GetODMSerial:                   RokuMfgLegacy_GetODMSerial,
        SetODMSerial:                   RokuMfgLegacy_SetODMSerial,
        GetTvBOMRev:                    RokuMfgLegacy_GetTvBOMRev,
        SetTvBOMRev:                    RokuMfgLegacy_SetTvBOMRev,
        GetFactoryRemote:               RokuMfgLegacy_GetFactoryRemote,
        SetFactoryRemote:               RokuMfgLegacy_SetFactoryRemote,
        GetAgingMode:                   RokuMfgLegacy_GetAgingMode,
        SetAgingMode:                   RokuMfgLegacy_SetAgingMode,
        SaveODMInformation:             RokuMfgLegacy_SaveODMInformation,
        FetchODMInformation:            RokuMfgLegacy_FetchODMInformation,
        GetDisplaySize:                 RokuMfgLegacy_GetDisplaySize,
        GetPanelFrequency:              RokuMfgLegacy_GetPanelFrequency,
        SetPanelFrequency:              RokuMfgLegacy_SetPanelFrequency,
        GetPanelFlip:                   RokuMfgLegacy_GetPanelFlip,
        SetPanelFlip:                   RokuMfgLegacy_SetPanelFlip,
        GetPanelMirror:                 RokuMfgLegacy_GetPanelMirror,
        SetPanelMirror:                 RokuMfgLegacy_SetPanelMirror,
        SetTestPatternsVideoPlane:      RokuMfgLegacy_SetTestPatternsVideoPlane,
        SetTestPatternColor:            RokuMfgLegacy_SetTestPatternColor,
        SetPeripheral:                  RokuMfgLegacy_SetPeripheral,
        SetUBKeyValue:                  RokuMfgLegacy_SetUBKeyValue,
        GetUBKeyValue:                  RokuMfgLegacy_GetUBKeyValue,
        SetTestPatternRGBColor:         RokuMfgLegacy_SetTestPatternRGBColor,
        SetTestPatternIRE:              RokuMfgLegacy_SetTestPatternIRE,
        GetHdmiEdid:                    RokuMfgLegacy_GetHdmiEdid,
        GetHdmiEdidByMode:              RokuMfgLegacy_GetHdmiEdidByMode,
        GetHdmiHdcp14Ksv:               RokuMfgLegacy_GetHdmiHdcp14Ksv,
        GetHdmiHdcp22ReceiverId:        RokuMfgLegacy_GetHdmiHdcp22ReceiverId,
        GetHdmiArcEnable:               RokuMfgLegacy_GetHdmiArcEnable,
        SetHdmiArc:                     RokuMfgLegacy_SetHdmiArc,
        GetSystemAudioControl:          RokuMfgLegacy_GetSystemAudioControl,
        SetSystemAudioControl:          RokuMfgLegacy_SetSystemAudioControl,
        GetSupportedLanguageCodes:      RokuMfgLegacy_GetSupportedLanguageCodes,
        GetLanguage:                    RokuMfgLegacy_GetLanguage,
        SetLanguage:                    RokuMfgLegacy_SetLanguage,
        GetAllSources:                  RokuMfgLegacy_GetAllSources,
        GetSource:                      RokuMfgLegacy_GetSource,
        SetSource:                      RokuMfgLegacy_SetSource,
        GetLastSource:                  RokuMfgLegacy_GetLastSource,
        GetLvdsSscEnable:               RokuMfgLegacy_GetLvdsSscEnable,
        GetLvdsDriveStrength:           RokuMfgLegacy_GetLvdsDriveStrength,
        SetLvdsDriveStrength:           RokuMfgLegacy_SetLvdsDriveStrength,
        GetLvdsSscParameters:           RokuMfgLegacy_GetLvdsSscParameters,
        SetLvdsSscParameters:           RokuMfgLegacy_SetLvdsSscParameters,
        GetVCOMLevel:                   RokuMfgLegacy_GetVCOMLevel,
        SetVCOMLevel:                   RokuMfgLegacy_SetVCOMLevel,
        GetODMGammaTable:               RokuMfgLegacy_GetODMGammaTable,
        UpdateODMGammaTable:            RokuMfgLegacy_UpdateODMGammaTable,
        ApplyODMGammaTable:             RokuMfgLegacy_ApplyODMGammaTable,
        WriteHDCP14RxEncryptedKey:      RokuMfgLegacy_WriteHDCP14RxEncryptedKey,
        ReadHDCP14RxKey:                RokuMfgLegacy_ReadHDCP14RxKey,
        WriteHDCP22RxEncryptedKey:      RokuMfgLegacy_WriteHDCP22RxEncryptedKey,
        ReadHDCP22RxKey:                RokuMfgLegacy_ReadHDCP22RxKey,
        CleanPCPanelCalib:              RokuMfgLegacy_CleanPCPanelCalib,
        UnzipData:                      RokuMfgLegacy_UnzipData,
        GetSupportedModels:             RokuMfgLegacy_GetSupportedModels,
        GetRokuModel:                   RokuMfgLegacy_GetRokuModel,
        SetRokuModel:                   RokuMfgLegacy_SetRokuModel,
        SetCPUXTAL:                     RokuMfgLegacy_SetCPUXTAL,
        GetCPUXTAL:                     RokuMfgLegacy_GetCPUXTAL,
        ExtendCustomConfig:             RokuMfgLegacy_ExtendCustomConfig,
        GetExtendedCustomConfig:        RokuMfgLegacy_GetExtendedCustomConfig,
        StartChecksumProcess:           RokuMfgLegacy_StartChecksumProcess,
        GetAllChecksumValues:           RokuMfgLegacy_GetAllChecksumValues,
        SetGPIO:                        RokuMfgLegacy_SetGPIO,
        TristateGPIO:                   RokuMfgLegacy_TristateGPIO,
        SetRasterPattern:               RokuMfgLegacy_SetRasterPattern,
        SetIRModeRaw:                   RokuMfgLegacy_SetIRModeRaw,
        GetInputSignalState:            RokuMfgLegacy_GetInputSignalState,
        SetPCKeyValue:                  RokuMfgLegacy_SetPCKeyValue,
        GetPCKeyValue:                  RokuMfgLegacy_GetPCKeyValue,
        GetCustomKeyValue:              RokuMfgLegacy_GetCustomKeyValue,
        SetRTCWakeup:                   RokuMfgLegacy_SetRTCWakeup,
        SetBacklightFrequency:          RokuMfgLegacy_SetBacklightFrequency,
        GetBacklightFrequency:          RokuMfgLegacy_GetBacklightFrequency,
        SetBacklightLevel:              RokuMfgLegacy_SetBacklightLevel,
        GetBacklightLevel:              RokuMfgLegacy_GetBacklightLevel,
        SetBoot2Suspend:                RokuMfgLegacy_SetBoot2Suspend,
        GetBoot2Suspend:                RokuMfgLegacy_GetBoot2Suspend,
        GetPOSFileStatus:               RokuMfgLegacy_GetPOSFileStatus,
        POSSilentUpdate:                RokuMfgLegacy_POSSilentUpdate,
        VerticalFreqState:              RokuMfgLegacy_VerticalFreqState,
        ProgramTconI2CDevice:           RokuMfgLegacy_ProgramTconI2CDevice
    }

    return apis
end function

sub RokuMfgLegacyInfo()
    field = "legacy"
    constants = getGlobalAA().mfg_constants

    if not constants.hasField(field) then
        print "Init Platform Info"
        f = {}
        f[field] = {
            PC_AUTOBOOT_ON: &h2835A8A8,
            PC_AUTOBOOT_OFF: &hDC749001,
            flag_custom_pkg_ext: [
                "MODEL_HAS_WIFI_REMOTE",
                "MODEL_SHIPS_WITH_ENHANCED_REMOTE",
                "MODEL_SHIPS_WITH_VOICE_REMOTE",
                "MODEL_HAS_REMOTE_FINDER"
            ],
            field_custom_pkg_ext: [
                "DEFAULT_LANG",
                "DEFAULT_LOCALE"
            ]
        }

        constants.addFields(f)
    end if
end sub
