'*********************************************************************
'** (c) 2018 Roku, Inc.  All content herein is protected by U.S.
'** copyright and other applicable intellectual property laws and may
'** not be copied without the express permission of Roku, Inc., which
'** reserves all rights.  Reuse of any of this content for any purpose
'** without the permission of Roku, Inc. is strictly prohibited.
'*********************************************************************
' Roku_MFG_API_Barcode.brs
' Barcode screen APIs

function RokuMfgApi_Barcode(mfg as Object, pl as Object) as Object
    if not RokuMfgIsBool(pl.enable) then
        return RokuMfgBadDataStatus("expected enable as boolean flag")
    end if

    screen = getGlobalAA().mfg_screen
    scene = screen.getScene()
    if invalid = scene then
        scene = screen.createScene("roku_mfg_lib:RokuMfgBarcode")
        screen.show()
    end if

    if pl.enable then
        ' It's possible we want to show/hide the barcode without updating
        ' the text/color, so only update the text if it was provided.
        if RokuMfgIsString(pl.data) then
            barcode = scene.findNode("barcode")
            barcode.text = pl.data
        end if

        if RokuMfgIsInt(pl.color) then
            color = stri(pl.color and &hffffffff, 16)
            while len(color) <> 8
                color = "0" + color
            end while

            color = "0x" + color
            background = scene.findNode("background")
            background.color = color
        end if
    end if

    scene.visible = pl.enable
    return RokuMfgSuccessStatus()
end function
