'*********************************************************************
'** (c) 2018 Roku, Inc.  All content herein is protected by U.S.
'** copyright and other applicable intellectual property laws and may
'** not be copied without the express permission of Roku, Inc., which
'** reserves all rights.  Reuse of any of this content for any purpose
'** without the permission of Roku, Inc. is strictly prohibited.
'*********************************************************************

' MFG API Wrapper
Library "apis/Roku_MFG_API.brs"
Library "events/Roku_MFG_Events.brs"
Library "legacy/Roku_MFG_Legacy.brs"
Library "modules/Include.brs"
Library "util/Include.brs"

'*********************************************************************
'** RokuMFG
'** @brief Instantiate RokuMFG singleton in global AA
'**
'** @return instance of RokuMFG object
'*********************************************************************
function RokuMfg() As Object
    g_ = getGlobalAA()
    if g_.mfg_instance = invalid then
        g_.mfg_lib_apis = RokuMfgLibApis()
        g_.mfg_screen = CreateObject("roSGScreen")
        g_.mfg_constants = createObject("roSGNode", "roku_mfg_lib:Constants")
        o = {
            impl: createObject("roManufacturing"),
            port: createObject("roMessagePort"),
            checkEvent: RokuMfgEvents_CheckEvent,
            parseEvent: RokuMfgEvents_ParseEventRoot,
            checkResponse: RokuMfgCheckResponse,
            call: RokuMfgCallApi,
            legacy: RokuMfgLegacyApis(),
            util: RokuMfgUtilityApis(),

            libInfo: RokuMfgLibraryInfo,
            sysInfo: RokuMfgSystemInfo,
            platformInfo: RokuMfgPlatformInfo,
            pqInfo: RokuMfgPqInfo,
            aqInfo: RokuMfgAqInfo
        }

        o.impl.setMessagePort(o.port)

        ' Init info structures here to populate the ContentNode
        o.libInfo()
        o.sysInfo()
        o.platformInfo()
        o.pqInfo()

        ' Private structures only accessible to the library
        RokuMfgLegacyInfo()

        g_.mfg_instance = o
    end if

    return g_.mfg_instance
end function
