'*********************************************************************
'** (c) 2018 Roku, Inc.  All content herein is protected by U.S.
'** copyright and other applicable intellectual property laws and may
'** not be copied without the express permission of Roku, Inc., which
'** reserves all rights.  Reuse of any of this content for any purpose
'** without the permission of Roku, Inc. is strictly prohibited.
'*********************************************************************
' Manufacturing.brs
' Roku MFG utilities

function RokuMfgUtilityApis() as Object
    apis = {
        ' Platform type utils
        getChipType: RokuMfgGetChipType,
        isChipType: RokuMfgIsChipType,
        isSigmaPlatform: RokuMfgIsSigmaPlatform,
        isMStarPlatform: RokuMfgIsMStarPlatform,
        getDeviceType: RokuMfgGetDevicetype,
        isTvPlatform: RokuMfgIsTvPlatform,
        isWifiRssiStrong: RokuMfgIsWifiRssiStrong,

        ' Data utils
        merge: RokuMfgMerge,
        deepCopy: RokuMfgDeepCopy,
        isFilenameGood: RokuMfgIsFilenameGood,
        min: RokuMfgMin,
        max: RokuMfgMax,
        xor: RokuMfgXor,
        modulo: RokuMfgModulo,
        capitalize: RokuMfgCapitalize,

        ' Type utils
        hasInterface: RokuMfgHasInterface,
        isString: RokuMfgIsString,
        isInt: RokuMfgIsInt,
        isInteger: RokuMfgIsInt,
        isBool: RokuMfgIsBool,
        isBoolean: RokuMfgIsBool,
        isFloat: RokuMfgIsFloat,
        isArray: RokuMfgIsArray,
        isAA: RokuMfgIsAA
        isAssociativeArray: RokuMfgIsAA,
        isInvalid: RokuMfgIsInvalid,

        ' Casting utils
        strCast: RokuMfgStrCast,
        boolCast: RokuMfgBoolCast,
        intCast: RokuMfgIntCast
    }

    return apis
end function

function RokuMfgCallExternal(mfg as Object, cmd as String, payload as Object) as Object
    return RokuMfgConvertResponse(mfg.call(cmd, formatJson(payload)))
end function

' MFG Response utilities
function RokuMfgCheckResponse(res=invalid, verbose=true as Boolean) as Boolean
    if not RokuMfgIsAA(res) then
        return false
    end if

    if 0 <> res.header_.status then
        if true = verbose and not RokuMfgIsInvalid(res.header_.command) then
            print "Command " + res.header_.command + " failed with error code " + RokuMfgStrCast(res.header_.status)
            print "  Error description: " + res.header_.description
        end if
        return false
    end if

    return true
end function

function RokuMfgConvertResponse(res="" as String) as Object
    valid = false

    if "" <> res then
        ret = parseJSON(res)

        ' Validation:
        ' * Must be an roAA
        ' * Must have header_ member
        ' * header_ must be an roAA
        ' * header_ must have status member as Integer
        if RokuMfgIsAA(ret) and RokuMfgIsAA(ret.header_) and RokuMfgIsInt(ret.header_.status) then
            valid = true
        end if
    end if

    if not valid then
        ret = {
            header_: {
                status: 1,
                description: "invalid response"
            },
            data: ""
        }
    end if

    return ret
end function

function RokuMfgResponse(status=0 as Integer, desc="" as String, data={} as Object) as Object
    return {
        header_: {
            status: status,
            description: desc
        }
        data: data
    }
end function

function RokuMfgSuccessStatus(data={} as Object, desc="" as String) as Object
    return RokuMfgResponse(0, desc, data)
end function

function RokuMfgGenericStatus(desc="" as String, data={} as Object) as Object
    return RokuMfgResponse(1, desc, data)
end function

function RokuMfgBadCommandStatus(desc="" as String, data={} as Object) as Object
    return RokuMfgResponse(2, desc, data)
end function

function RokuMfgBadActionStatus(desc="" as String, data={} as Object) as Object
    return RokuMfgResponse(3, desc, data)
end function

function RokuMfgBadDataStatus(desc="" as String, data={} as Object) as Object
    return RokuMfgResponse(4, desc, data)
end function

function RokuMfgMfgModeStatus(desc="MFG mode required" as String, data={} as Object) as Object
    return RokuMfgResponse(5, desc, data)
end function

' Legacy API return utilities
function RokuMfgLegacySuccess(data={} as Object) as Object
    data.valid = 1
    return data
end function

function RokuMfgLegacyError(error="" as String) as Object
    return {
        valid: 0,
        error: error
    }
end function
