'*********************************************************************
'** (c) 2019 Roku, Inc.  All content herein is protected by U.S.
'** copyright and other applicable intellectual property laws and may
'** not be copied without the express permission of Roku, Inc., which
'** reserves all rights.  Reuse of any of this content for any purpose
'** without the permission of Roku, Inc. is strictly prohibited.
'*********************************************************************
Library "modules/Data/Range.brs"
Library "modules/Data/Selector.brs"
Library "modules/Data/String.brs"

'
' Construct and initialize a Data module object
' Provides the following functions:
' @see .constructString RokuMfgDataConstructString,
' @see .constructSelector RokuMfgDataConstructSelector,
' @see .constructRange RokuMfgDataConstructRange,
' @see .add RokuMfgDataAddDataToStore,
' @see .get RokuMfgDataGetDataFromStore,
' @see .getValue RokuMfgDataGetDataValueFromStore,
' @see .delete RokuMfgDataDeleteDataFromStore
'
' @param params roAssociativeArray of parameters to merge into the returned object.
'     Supported keys:
'     * app: A reference to the MFG APP global context
'     Also allows overriding default functionality and adding features not
'     provided by the default implementation.
'     Default is invalid.
'
' @return keyFilter a new roAssociativeArray wrapping keyFilter functionality
function RokuMfgDataModule(params=invalid as Object) as Object
    print "Initializing Data Module"
    data = {
        'A reference to the MFG APP global context.
        app: invalid

        ' Handlers for creating data members.
        constructString:   RokuMfgDataConstructString,
        constructSelector: RokuMfgDataConstructSelector,
        constructRange:    RokuMfgDataConstructRange,

        add: RokuMfgDataAddDataToStore,
        get: RokuMfgDataGetDataFromStore,
        getValue: RokuMfgDataGetDataValueFromStore,
        delete: RokuMfgDataDeleteDataFromStore,
        store: {}
    }

    if RokuMfgIsAA(params) then
        RokuMfgMerge(data, params)
    end if

    return data
end function

'
' Used to add defined "data" object into data store "store" . Should only be
' called as add from the RokuMfgDataModule() object.
'
' @param id the "id" of defined "data" object
' @param data the defined "data" object
'
' @return the defined "data" object after it has been added into data store "store"
function RokuMfgDataAddDataToStore(id as String, data as Object) as Object
    m.store[id] = data
    return m.store[id]
end function

'
' Used to get defined "data" object from data store "store" . Should only be
' called as get from the RokuMfgDataModule() object.
'
' @param id the "id" of "data" object to be gottern
'
' @return the defined "data" object gottern from data store "store"
function RokuMfgDataGetDataFromStore(id as String) as Object
    if RokuMfgIsInvalid(m.store[id]) then
        print "Error: no data with key '" + id + "' found!"
    end if

    return m.store[id]
end function

'
' Used to get the value of defined "data" object . Should only be called as getValue
' from the RokuMfgDataModule() object.
'
' @param id the "id" of "data" object to be gottern
'
' @return the value of defined "data" object
function RokuMfgDataGetDataValueFromStore(id as string)
    if false = RokuMfgIsAA(m.store[id]) or false = RokuMfgHasInterface(m.store[id].get, "ifFunction") then
        print "data.getValue (getDataValueFromStore) used on key " + id + " without get() method"
        return invalid
    end if

    return m.store[id].get()
end function

'
' Used to delete one defined "data" object from data store "store" . Should only
' be called as delete from the RokuMfgDataModule() object.
'
' @param id the "id" of "data" object to be deleted
sub RokuMfgDataDeleteDataFromStore(id as string)
    if RokuMfgIsAA(m.store[id]) then
        m.store.delete(id)
    end if
end sub