'*********************************************************************
'** (c) 2018 Roku, Inc.  All content herein is protected by U.S.
'** copyright and other applicable intellectual property laws and may
'** not be copied without the express permission of Roku, Inc., which
'** reserves all rights.  Reuse of any of this content for any purpose
'** without the permission of Roku, Inc. is strictly prohibited.
'*********************************************************************
' Roku_MFG_API_TV.brs
' Implementation of APIs specific to TV products
Library "state/Roku_MFG_State.brs"

function RokuMfgApi_Projects(mfg as Object, pl as Object) as Object
    if not RokuMfgIsTVPlatform() or RokuMfgIsSigmaPlatform() then
        return RokuMfgGenericStatus("projects not supported on this platform")
    end if

    ' The weight corresponds to which bit to set
    keys = {
        id: {
            pc: "projectid",
            wieght: 31
        },
        panel_index: {
            pc: "panel",
            weight: 5
        },
        roku_model: {
            pc: "rokumodel",
            weight: 4
        },
        oem_model: {
            pc: "odmmodel",
            weight: 3
        },
        speaker_index: {
            pc: "speaker",
            weight: 2
        },
        default_locale: {
            pc: "DEFAULT_LOCALE",
            weight: 1
        },
        default_language: {
            pc: "DEFAULT_LANG",
            weight: 0
        }
    }

    ' FIXME: tfranklin: improve this to only get the list once. It's not going to change
    ' Always get the list here to return or operate on.
    projects = RokuMfgCallExternal(mfg, "projects", pl)
    if RokuMfgIsInvalid(pl.action) then
        return projects
    else if not RokuMfgIsString(pl.action) then
        return RokuMfgBadActionStatus("expected action as string")
    else if "get" = pl.action then
        if not RokuMfgIsString(pl.data) then
            return RokuMfgBadDataStatus("expected data as string")
        else if "all" = pl.data then
            return projects
        else if "current" = pl.data then
            data = []
            for each key in keys
                data.push(keys[key].pc)
            end for

            pc = RokuMfgCallExternal(mfg, "pc", {
                header_: pl.header_,
                action: "get",
                data: data
            })

            if not RokuMfgCheckResponse(pc)
                return RokuMfgGenericStatus("failed to get current configuration")
            end if

            best_weight = 0
            best_match = invalid
            for each id in projects.data
                id_weight = 0
                for each key in keys
                    if "" <> pc.data[keys[key].pc] and not RokuMfgIsInvalid(id[key]) then
                        if RokuMfgStrCast(id[key]) = pc.data[keys[key].pc] then
                            id_weight = id_weight or (1 << keys[key].weight)
                        end if
                    end if
                end for

                if id_weight > best_weight then
                    best_weight = id_weight
                    best_match = id
                end if
            end for

            if RokuMfgIsInvalid(best_match) then
                return RokuMfgGenericStatus("failed to find matching project")
            end if

            return RokuMfgSuccessStatus(best_match)
        else
            return RokuMfgBadDataStatus("unknown data")
        end if
    else if "set" = pl.action then
        if not RokuMfgIsAA(pl.data) then
            RokuMfgBadDataStatus("expected data as project ID associative array")
        end if

        data = {}
        for each key in keys
            if not RokuMfgIsInvalid(pl.data[key])
                data[keys[key].pc] = pl.data[key]
            end if
        end for

        return RokuMfgCallExternal(mfg, "pc", {
            header_: pl.header_,
            action: "set",
            data: data
        })
    end if

    return RokuMfgBadActionStatus("unknown action")
end function

function RokuMfgApi_InputSource(mfg as Object, pl as Object) as Object
    get_map = {
        "dtv": "tuner"
    }

    if "set" = pl.action then
        if RokuMfgIsInvalid(pl.data) then
            ' If data wasn't provided, assume "ui"
            pl.data = "ui"
        else if not RokuMfgIsString(pl.data) then
            return RokuMfgBadDataStatus("expected data as string")
        end if

        set_map = {
            "network":      "ui",
            "streaming":    "ui",
            "":             "ui",
            "av":           "cvbs",
            "composite":    "cvbs",
            "atv":          "dtv",
            "tuner":        "dtv"
        }

        pl.data = lcase(pl.data)
        if not RokuMfgIsInvalid(set_map[pl.data]) then
            pl.data = set_map[pl.data]
        end if
    else if "get" = pl.action then
        key = invalid
        if "signalstate" = pl.data then
            signal = RokuMfgState().get("TVSignalState")
            mode = RokuMfgState().get("TVSignalMode")
            ret = {state: signal}
            if -1 <> signal.instr("valid") then
                ret.mode = mode
            end if

            return RokuMfgSuccessStatus(ret)
        else if RokuMfgIsInvalid(pl.data) or "current" = pl.data then
            key = "CurrentInputSource"
        else if "last" = pl.data then
            key = "LastInputSource"
        end if

        if not RokuMfgIsInvalid(key) then
            source = RokuMfgState().get(key)
            if not RokuMfgIsInvalid(get_map[source]) then
                source = get_map[source]
            end if

            return RokuMfgSuccessStatus(source)
        end if
    end if

    ret = RokuMfgCallExternal(mfg, "inputsource", pl)
    if RokuMfgCheckResponse(ret) then
        if "get" = pl.action then
            if "all" = pl.data then
                for i=0 to ret.data.count() - 1
                    if not RokuMfgIsInvalid(get_map[ret.data[i]]) then
                        ret.data[i] = get_map[ret.data[i]]
                        get_map.delete(ret.data[i])

                        if 0 = get_map.count() then
                            exit for
                        end if
                    end if
                end for
            else
                if not RokuMfgIsInvalid(get_map[ret.data]) then
                    ret.data = get_map[ret.data]
                end if
            end if
        else if "set" = pl.action then
            ' Wait to update our internal state until after we confirm success
            RokuMfgState().set("LastInputSource", RokuMfgState().get("CurrentInputSource"))
            RokuMfgState().set("CurrentInputSource", pl.data)
        end if
    end if

    return ret
end function
