'*********************************************************************
'** (c) 2018 Roku, Inc.  All content herein is protected by U.S.
'** copyright and other applicable intellectual property laws and may
'** not be copied without the express permission of Roku, Inc., which
'** reserves all rights.  Reuse of any of this content for any purpose
'** without the permission of Roku, Inc. is strictly prohibited.
'*********************************************************************
' Roku_MFG_PQ.brs
' Implementation of APIs used for Picture Quality
function RokuMfgApi_Gamma(mfg as Object, pl as Object) as Object
    keyCheck = ["action", "component", "table", "color", "field"]
    for each key in keyCheck
        if RokuMfgIsString(pl[key]) then
            pl[key] = lcase(pl[key])
        end if
    end for

    ret = RokuMfgCallExternal(mfg, "gamma", pl)
    if RokuMfgCheckResponse(ret) then
        if not RokuMfgIsInvalid(ret.error) then
            return RokuMfgGenericStatus(ret.error)
        else if not RokuMfgIsInvalid(ret.data) and not RokuMfgIsInvalid(ret.data.data) then
            ' Response gets wrapped such that the returned data
            ' is nested inside of data. Bring it up a level.
            ret.data = ret.data.data
        end if
    end if

    return ret
end function
