' Roku_MFG_API_Audio.brs
Library "state/Roku_MFG_State.brs"

function RokuMfgApi_Audio(mfg as Object, pl as Object) as Object
    if "set" = pl.action then
        if "output" = pl.component then
            if not isString(pl.data) then
                return RokuMfgBadDataStatus("expected data as destination string")
            end if

            dest = lcase(pl.data)
            if isChipType("MStar-C2") and dest = "all" then
                ret = RokuMfgCallExternal(mfg, "aq", {
                    header_: pl.header_,
                    action: "set",
                    component: "output",
                    data: dest,
                    enable: true,
                    level: 100
                })
            else
                ret = RokuMfgCallExternal(mfg, "aq", {
                    header_: pl.header_,
                    action: "set",
                    component: "output",
                    data: dest,
                    enable: true,
                    level: 100
                })
            end if

            return ret
        else if "input" = pl.component then
            if not isString(pl.data) then
                return RokuMfgBadDataStatus("expected data as input destination string")
            end if

            if "bluetooth" = pl.data then
                input = "bluetootha2dp"
            else
                input = pl.data
            end if

            return RokuMfgCallExternal({
                header_: pl.header_,
                action: pl.action,
                component: pl.component,
                data: input
            })
        end if
    end if

    return RokuMfgCallExternal(mfg, "aq", pl)
end function

function RokuMfgApi_Dts(mfg as Object, pl as Object) as Object
    ' tfranklin: DTS handling is currently maintained in the device layer, meaning
    ' it's possible we'll see multiple diverging implementations by platform.
    ' It's not ideal, but I've restricted this to MSTAR only so that if/when
    ' we expose for other vendors, we get an obvious error to revisit this.
    if isMStarPlatform() then
        if not isString(pl.action) then
            return RokuMfgBadActionStatus("expected action as string")
        else if not isString(pl.component) then
            return RokuMfgBadDataStatus("expected component as string")
        end if

        ' Get a copy of the pl here so we can add the type for use by the
        ' underlying firmware call without modifying the user's object
        plcpy = deepCopy(pl)
        plcpy.type = "DTSSetup"
        ret = RokuMfgCallExternal(mfg, "dts", plcpy)
        ret.data = parseJSON(ret.data)
        return ret
    end if

    return RokuMfgGenericStatus("unsupported on this platform")
end function
