function constructStringUI(params as Object) as Object
    o = m.constructBaseUINode({
        label: "String",
        type: "String",
        displayMode: "Always",
        data: invalid,
        action: invalid,
        handleKey: handleStringKey,
        getDisplayValue: getStringUIDisplayValue,
        calculateWidth: calculateStringUIWidth,
        draw: drawStringUI
    })

    o = RokuMfgMerge(o, params)
    return o
end function

function handleStringKey(keycode as Integer)
    if (m.app.keycodes["RIGHT"] = keycode or m.app.keycodes["SELECT"] = keycode) and "roFunction" = type(m.action) then
        m.action()
        return invalid
    end if

    return keycode
end function

function getStringUIDisplayValue() as String
        value = m.data
        dtype = type(m.data)

        ' Stringify any reasonable type

        if "roFunction" = dtype or "Function" = dtype then
            value = m.data()
            dtype = type(value)
        end if

        if "roInt" = dtype then
            value = StrI(value.getInt(), 10)
        else if "roInteger" = dtype or "Integer" = dtype then
            value = StrI(value, 10)
        else if "roFloat" = dtype or "Float" = dtype then
            value = Str(value)
        else if "roObject" = dtype or "roAssociativeArray" = dtype then
            ' Handle a "Data" string
            if "String" = value.class_ then
                value = value.get()
            else
                ' We don't know what to show, in this case.
                value = "{...}"
            end if
        else if "roArray" = dtype then
            value = "[...]"
        else if "Invalid" = dtype then
            value = ""
        end if

        return value
end function

function calculateStringUIWidth(font as Object, baseWidth as Integer) as Integer
    return font.GetOneLineWidth(m.getDisplayValue(), baseWidth)
end function

sub drawStringUI(ctx as Object, layout as Object, params as Object)
    ctx.drawMenuLabel(layout, params, m)

    if m.shouldShowValue(ctx, params) then
        params.depth = params.depth + 1
        ctx.drawMenuLabel(layout, params, {label: m.getDisplayValue()})
    end if
end sub