function constructFileEntryUI(params as Object) as Object
    o = m.constructBaseUINode({
        type: "FileEntry",
        data: {
            name: "FileEntry",
            size: 0
        },
        displayMode: "Always",
        handleKey: handleFileEntryKey,
        action: invalid,
        draw: drawFileEntryUI,
        getDisplayValue: getFileEntryDisplayValue,
        calculateWidth: calculateFileEntryUIWidth,
    })


    o = RokuMfgMerge(o, params)
    o.label = o.data.name

    return o
end function

function handleFileEntryKey(keycode as Integer)
    if m.app.keycodes["SELECT"] = keycode and "roFunction" = type(m.action) then
        m.action(m.data)
        return invalid
    end if

    return keycode
end function

function getFileEntryDisplayValue() as String
    return toFileSizeString(m.data.size)
end function

function calculateFileEntryUIWidth(font as Object, baseWidth as Integer) as Integer
    return font.GetOneLineWidth(m.getDisplayValue(), baseWidth)
end function

sub drawFileEntryUI(ctx as Object, layout as Object, params as Object)
    ctx.drawMenuLabel(layout, params, m)

    if m.shouldShowValue(ctx, params) then
        params.depth = params.depth + 1
        ctx.drawMenuLabel(layout, params, {label: m.getDisplayValue()})
    end if
end sub

function toFileSizeString(size as Integer)
    denote = ["B", "KB", "MB", "GB"]
    remainder = 0
    output = ""

    while size > 1024
        denote.shift()
        remainder = (size mod 1024) / 100
        size = size / 1024
    end while

    output = RokuMfgStrCast(size)

    if remainder > 0 then
        output = output + "." + RokuMfgStrCast(remainder)
    end if

    output = output + denote[0]
    return output
end function