function showSimpleScreen(text)
    data = {
        text: "Simple Text"
    }

    if "roAssociativeArray" = type(text) then
        data = RokuMfgMerge(data, text)
    else if "String" = type(text) or "roString" = type(text) then
        data.text = text
    else 
        print "showSimpleScreen: Bad parameter type provided " + type(text)
        return {}
    end if

    o = {
        name: "_simpleScreen_"
        app: m.app,
        ui: m,

        keyfilter: simpleScreenKeyFilter,
        prepare: prepareSimpleScreen,

        data: data,
        background: m.resolveColor(data.background, "gray")
    }

    m.app.pushScreen(o)
    return o
end function

sub prepareSimpleScreen()
    b = m.ui.layoutBox({
        padding: 20
        color: m.background
    })

    b.push(m.ui.layoutText(m.data))
    b.x = (m.app.screen.width - b.getWidth()) / 2
    b.y = (m.app.screen.height - b.getHeight()) / 2

    m.app.screen.menuItems.items = [b]
end sub

function simpleScreenKeyFilter(context as Object, keycode as Integer)
    if keycode = context.app.keycodes["BACK"] or keycode = context.app.keycodes["MENU"] or keycode = context.app.keycodes["F6"] then
        context.app.exitScreen()
        return invalid
    end if

    return keycode
end function

sub exitSimpleScreenOSD()
    ' Global call to remove SimpleScreen from OSD onDelete call.
    ' OSD object must contain entry for "app" as this call will
    ' be from within the OSD scope.
    m.app.exitScreen()
end sub
