function constructResetSettingsMenu(app as Object) as Object
    o = {
        name: "ResetSettings",
        app: app,
        ui: app.ui,
        ConstructResetSettingsDataMenu     : ConstructResetSettingsDataMenu
    }

    o.menuRoot               = o.ConstructResetSettingsDataMenu()
    o.Delete("ConstructResetSettingsDataMenu")
    o = RokuMfgMerge(o, app.ui.screenstack.screenregistry["Main"], false)

    return o
end function

function ConstructResetSettingsDataMenu() As Object
    menu = m.ui.constructSMenu({
        label: "Reset All Settings",
    })

    menu.addItem(m.ui.constructAction({
        label: "Go Back",
        data: doGoBack
    }))

    menu.addItem(m.ui.constructSelector({
        label: "Reset Level",
        data: m.app.data.get("pqresetlevel")
    }))

    menu.addItem(m.ui.constructAction({
        label: "Reset Layer Settings",
        data: doResetSettings
    }))

    return menu
end function

sub doResetSettings()
    ' Only wipe settings at the selected layer
    ret = RokuMfg().call("pq", {
        action: "reset",
        data: lcase(m.app.data.getValue("pqresetlevel")),
        current: true,
        global: false
    })

    if RokuMfgCheckResponse(ret) then
        ret = RokuMfg().call("pq", {
            action: "save",
            component: "database"
        })

        if RokuMfgCheckResponse(ret) then
            RokuMfg().call("pq", {action: "apply"})
            m.app.currentScreen().menuroot.selectedChild = 0
            m.app.ui.screenstack.pop()
        end if
    end if
end sub
