function constructNoOverlay(app as Object) as Object
    o = {
        name: "NoOverlay",
        app: app,
        ui: app.ui,
        prepare: prepareNoOverlayMenu,
        keyFilter: NoOverlayKeyFilter,
        handleKeys: handleNoOverlayKeys,
        drawM: drawNoOverlay,
    }

    return o
end function

sub prepareNoOverlayMenu()
    layout = []
    m.drawM(layout)
    m.app.screen.menuItems.items = layout
end sub

function NoOverlayKeyFilter(context as Object, keycode)
    return context.handleKeys(keycode)
end function

function handleNoOverlayKeys(keycode)
    if 1 = m.ui.screenstack.stack.count() then
        m.app.pushScreen("Main")            
    else
        m.ui.screenstack.pop()
    end if

    m.app.screen.osds.delete("DisplayMenu")
    return invalid
end function

sub drawNoOverlay(layout As Object)
    return
end sub