function constructVideoCurveMenu(app as object) as object
    o = {
        name                : "VideoCurveMenu",
        app                 : app,
        ui                  : app.ui,
        constructCurveData  : constructCurveData
    }

    o.menuRoot = o.constructCurveData()
    o.delete("constructCurveData")

    o = RokuMfgMerge(o, app.ui.screenStack.screenRegistry["Main"], false)

    o.dimensions = o.app.ui.calculateMenuColumns(o.menuRoot)

    ' The '+ 3' pads the height for the title
    o.dimensions.totalHeight = o.dimensions.rowHeight * (o.dimensions.maxRows + 3)

    return o
end function

function constructCurveData() as object
    menu = m.ui.constructSMenu({
        label: "Video Curve"
    })

    validcurves = {
        pqnames : []
        uinames : []
    }
    suffix = "_Curve"
    for each item in m.app.data.pqstore
        if inStr(item, suffix) then
            curve = m.app.data.get(item)
            validcurves.pqnames.push(curve.id)
            validcurves.uinames.push(left(curve.id, curve.id.len() - suffix.len()))
        end if
    end for

    menu.addItem(m.ui.constructSelector({
        label   : "Curve",
        data    : m.app.data.constructSelector({
                    id      : "VideoCurves",
                    app     : m.app,
                    dataset : validcurves.uinames,
                    values  : validcurves.pqnames,
                    onUpdate: updateVideoCurveMenu
                })
    }))

    curvename = menu.children[0].data.index
    curvename = validCurves.pqnames[curvename]

    curve = m.app.data.get(curvename).value
    curve = curve.tokenize(",")
    refPts = []
    for i = 0 to curve.count() - 1 step 2
        refPts.push(curve[i])
    end for

    for each point in refPts
        refCurve = m.app.data.get(curvename + "_" + point)
        menu.addItem(m.ui.constructRange({
            label   : "Reference: " + point
            data    : refCurve
        }))
    end for

    return menu
end function

sub updateVideoCurveMenu()
    nextcurve = m.app.data.get("VideoCurves")
    nextcurve = nextcurve.values[nextcurve.index]

    menu = m.app.ui.screenstack.getCurrent().menuroot
    itemcount = menu.children.count() - 1
    while true
        if menu.children.count () > 1 then
            menu.children.delete(itemcount)
        else
            exit while
        end if

        itemcount = itemcount - 1
    end while

    nextcurvevalues = m.app.data.get(nextcurve).value
    nextcurvevalues = nextcurvevalues.tokenize(",")
    refPts = []
    for i = 0 to nextcurvevalues.count() - 1 step 2
        refPts.push(nextcurvevalues[i])
    end for

    for each point in refPts
        refCurve = m.app.data.get(nextcurve + "_" + point)
        menu.addItem(m.app.ui.constructRange({
            label   : "Reference: " + point
            data    : refCurve
        }))
    end for
end sub