function constructUsbUpdateMenu(app as Object) as Object
    o = {
        name: "USB Update"
        app: app
        ui: app.ui
        ConstructUsbMenu     : ConstructUsbMenu
    }

    o.menuRoot               = o.ConstructUsbMenu()
    o.Delete("ConstructUsbMenu")
    o = RokuMfgMerge(o, app.ui.screenstack.screenregistry["Main"], false)

    return o
end function

function ConstructUsbMenu() As Object
    menu = m.ui.constructSMenu({
        label: m.name,
    })

    menu.addItem(m.ui.constructAction({
        label: "Go Back",
        data: doGoback
    }))

    menu.addItem(m.ui.constructAction({
        label: "Perform USB Update",
        data: doUsbUpdate
    }))

    return menu
end function

sub doUSBUpdate()
    if true = m.app.video.getPlaybackStatus().playing then
        m.app.video.pause()
    end if

    m.app.update.start()

    if true = m.app.video.getPlaybackStatus().paused then
        m.app.video.resume()
    end if
end sub
