function constructTunerChannelsMenu(app as Object) as Object
    o = {
        name: "TunerChannels",
        app: app,
        ui: app.ui,
        constructTunerChannelsMenuItems: constructTunerChannelsMenuItems,
        onEntry: enterTunerChannelsMenu
    }

    o.menuRoot               = o.constructTunerChannelsMenuItems()
    o.Delete("constructTunerChannelsMenuItems")
    o = RokuMfgMerge(o, app.ui.screenstack.screenregistry["Main"], false)

    return o
end function

function constructTunerChannelsMenuItems() as Object
    menu = m.ui.constructSMenu({label: "Tuner Channels"})
    return menu
end function

function enterTunerChannelsMenu()
    index = 0
    ret = m.app.mfg.legacy.getChannelInfoByIndex(index)
    while RokuMfgCheckLegacyResponse("getChannelInfoByIndex", ret)
        label = RokuMfgStrCast(ret.channel)
        if ret.isDigital then
            label = label + "." + RokuMfgStrCast(ret.subchannel)
        end if

        m.menuroot.addItem(m.ui.constructAction({
            label: label,
            data: setTunerChannel
        }))

        index = index + 1
        ret = m.app.mfg.legacy.getChannelInfoByIndex(index)
    end while

    if 0 = m.menuroot.children.count() then
        m.menuroot.addItem(m.ui.constructString({
            label: "(No Tuner Channels Found)"
        }))
    end if
end function

sub setTunerChannel()
    channel_split = m.label.split(".")
    channel = channel_split[0]
    if 1 < channel_split.count() then
        subchannel = strtoi(channel_split[1])
    else
        subchannel = invalid
    end if
    m.app.tuner.goToChannel(strtoi(channel), subchannel)
end sub
