function constructMainMenu(app as object) as object
	o = {
		name: "Main",
		app	: app,
		ui	: app.ui,

		constructHomeMenu   : constructHomeMenu,
		keyFilter 			: menuKeyFilter,
		handleKeys 			: handleMenuKeys,
		prepare 			: prepareMenuLayer,

		drawMenuBackground	: drawMenuBackground,
		drawTitle			: drawTitle,
        drawMenuLabel       : drawMenuLabel
	}

	o.menuRoot = o.constructHomeMenu()
	o.delete("constructHomeMenu")

	o.dimensions = o.app.ui.calculateMenuColumns(o.menuRoot)

	' The '+ 3' pads the height for the title
    o.dimensions.totalHeight = o.dimensions.rowHeight * (o.dimensions.maxRows + 3)

    return o
end function

sub PrepareMenuLayer()
    layout = []
    m.drawMenuBackground(layout)
    m.drawTitle(layout)

    params = {
        selected: true,
        selected_color: "orange",
        offset: 0,
        depth: -1,
    }

    m.menuRoot.draw(m, layout, params)
    m.app.screen.menuItems.items = layout
end sub

function menuKeyFilter(context as Object, keycode as Integer)
    return context.handleKeys(keycode)
end function

function handleMenuKeys(keycode as Integer)
    activeItem = m.menuRoot.getSelected()
'   menuString = "Context before Keypress: " + activeItem.label

    while invalid <> activeItem.getSelected and invalid <> activeItem.getSelected()
        activeItem = activeItem.getSelected()
    end while
'   menuString = menuString + "->" + activeItem.label

    activeItem = activeItem.parent
    return activeItem.handleKey(keycode)
end function

sub drawMenuBackground(layout as Object)
    ' Light gray border
    layout.Push(m.ui.layoutRectangle({
        x: m.dimensions.x
        y: m.dimensions.y
        w: m.dimensions.totalWidth
        h: m.dimensions.totalHeight
        color: "gray40"
        alpha: false
    }))

    ' Transparent black body
    layout.Push(m.ui.layoutRectangle({
        x: m.dimensions.x + 5
        y: m.dimensions.y + 5
        w: m.dimensions.totalWidth - 10
        h: m.dimensions.totalHeight - 10
        color: "trans_black"
    }))
end sub

sub DrawTitle(layout as Object)
    font = m.ui.fonts["title"]
    label = m.menuRoot.label
    x = font.GetOneLineWidth(label, m.dimensions.totalWidth)
    x = m.dimensions.x + (m.dimensions.totalWidth / 2) - (x / 2)

    layout.Push(m.ui.layoutText({
        text: label
        color: "white"
        font: font
        x: x
        y: 20
    }))
end sub

sub drawMenuLabel(layout as Object, params as Object, node as Object)
    if 0 < params.depth then
        ' If this column is not the leftmost, center
        font = m.ui.fonts["default"]

        if type(node.label).inStr("String") = -1 then
            node.label = str(node.label)
        end if

        w = font.getOneLineWidth(node.label, m.dimensions.totalWidth)
        x = m.dimensions.columnLeftOffsets[params.depth] - (w / 2)
    else
        x = m.dimensions.columnLeftOffsets[params.depth]
    end if

    if node.label = invalid then
        stop
    end if
    
    o = m.ui.layoutText({
        text: node.label,
        color: params.color,
        x: x,
        y: m.app.screen.visibleTop + ((params.offset + 1) * m.dimensions.rowHeight)
    })

    layout.push(o)
end sub

function constructHomeMenu() as object
    isService = (m.app.runlevel = "service")
    menu = m.ui.constructSMenu({
        label   : "Main Menu",
        type    : "SMenu"
    })  

    menu.addItem(m.ui.constructAction({
        label   : "PQ Menu >",
        screen  : "PQMenu",
        data    : enterMenu
    }))

    if false = isService and m.app.mfg.aqInfo().count() <> 0 then
        menu.addItem(m.ui.constructAction({
            label   : "AQ Menu >",
            screen  : "AQMenu",
            data    : enterMenu
        }))
    end if

    menu.addItem(m.ui.constructAction({
        label   : "Pattern Test >",
        screen  : "PatternTestMenu",
        data    : enterMenu
    }))

    m.changeVideoAction = m.ui.constructAction({
        label: "Change Streaming Video >",
        screen: "DMP",
        displayMode: "Always",
        data: enterMenu
    })
    menu.addItem(m.changeVideoAction)

    m.changeTunerAction = m.ui.constructAction({
        label: "Change Tuner Channel >",
        screen: "TunerChannels",
        displayMode: "Never",
        data: enterMenu
    })
    menu.addItem(m.changeTunerAction)

    if false = isService then
        menu.addItem(m.ui.constructSelector({
            label       : "CPU Xtal Level"
            data        : m.app.data.constructSelector({
                            id      : "CPUXTAL"
                            dataset : ["140", "132", "112", "90"]
                            onUpdate: updateCPUXtallevel
                        })
        }))
    end if

    menu.addItem(m.ui.constructSelector({
        label   : "Source",
        data    : m.app.data.get("InputSource")    
    }))

    if false = isService then
        menu.addItem(m.ui.constructAction({
            label: "USB Update >",
            screen: "USB Update",
            data: enterMenu
        }))
    end if

    menu.addItem(m.ui.constructString({
        label: "Roku TV Model",
        data: m.app.data.get("RokuTVModel")
    }))

    menu.addItem(m.ui.constructString({
        label: "OEM Model",
        data: m.app.data.get("OEMModel")  
    }))

    if false = isService then
        menu.addItem(m.ui.constructString({
            label: "Mode",
            data: m.app.data.getValue("ManufacturingMode")
        }))
    end if

    menu.addItem(m.ui.constructString({
        label: "Software Version",
        data: m.app.data.get("SoftwareVersion")   
    }))

    menu.addItem(m.ui.constructString({
        label: "ESN",
        data: m.app.data.get("RokuSN")  
    }))

    menu.addItem(m.ui.constructString({
        label   : "Brand",
        data    : m.app.data.get("Brand")
    }))

    if false = isService then
        menu.addItem(m.ui.constructString({
            label   : "Chip Type",
            data    : m.app.data.get("ChipType")
        }))

        menu.addItem(m.ui.constructString({
            label: "PQ Version",
            data: m.app.data.get("PQVersion")
        }))

        pinfo = m.app.mfg.platformInfo()
        if RokuMfgIsSigmaPlatform() then
            if "" = pinfo.tseversion then
                tse = "Unknown"
            else
                tse = pinfo.tseversion
            end if

            menu.addItem(m.ui.constructString({
                label: "TSE Version",
                data: m.app.data.constructString({
                    id: "tseversion",
                    value: tse
                })
            }))

            if "" = pinfo.tsebuildtime then
                tse = "Unknown"
            else
                tse = pinfo.tsebuildtime
            end if

            menu.addItem(m.ui.constructString({
                label: "TSE Build Time",
                data: m.app.data.constructString({
                    id: "tsebuildtime",
                    value: tse
                })
            }))
        else if RokuMfgIsMStarPlatform() then
            menu.addItem(m.ui.constructString({
                label: "QMap Version",
                data: m.app.data.constructString({
                    id: "qmapversion",
                    value: pinfo.mainqmap + "." + pinfo.smallqmap
                })
            }))
        else if RokuMfgIsRealtekPlatform() then
            menu.addItem(m.ui.constructString({
                label: "VIP Version",
                data: m.app.data.constructString({
                    id: "vipversion",
                    value: pinfo.vipversion
                })
            }))
            menu.addItem(m.ui.constructString({
                label: "ICM Version",
                data: m.app.data.constructString({
                    id: "icmversion",
                    value: pinfo.icmversion
                })
            }))
            menu.addItem(m.ui.constructString({
                label: "LD Version",
                data: m.app.data.constructString({
                    id: "ldversion",
                    value: pinfo.ldversion
                })
            }))
            menu.addItem(m.ui.constructString({
                label: "BLPF Version",
                data: m.app.data.constructString({
                    id: "blpfversion",
                    value: pinfo.blpfversion
                })
            }))
            menu.addItem(m.ui.constructString({
                label: "K-driver Version",
                data: m.app.data.constructString({
                    id: "kdrvversion",
                    value: pinfo.kdrvversion
                })
            }))
            if pinfo.Lookup("ipqversion") <> invalid then
                menu.addItem(m.ui.constructString({
                    label: "IPQ Version",
                    data: m.app.data.constructString({
                        id: "ipqversion",
                        value: pinfo.ipqversion
                    })
                }))
            end if
        end if

        menu.addItem(m.ui.constructString({
            label: "AQ Version",
            data: m.app.data.get("AQVersion")
        }))
    end if
    
    menu.addItem(m.ui.constructAction({
        label: "Hide Menu",
        data: hideMenu
    }))

    return menu
end function

sub doGoBack()
    m.ui.screenstack.pop()
end sub

sub enterMenu()
    m.ui.screenstack.push(m.screen)
end sub

sub hideMenu()
    m.app.pushScreen("NoOverlay")

    b = m.app.ui.layoutBox({
        padding: 20
        color: "black"
    })

    b.push(m.app.ui.layoutText({
        text: "Press OK to unhide menu",
        font: "medium"
    }))
    b.x = (m.app.screen.width - b.getWidth()) / 2
    b.y = (m.app.screen.height - b.getHeight()) / 2

    m.app.screen.addOSD(m.app.timer.totalMilliseconds(), {
        name: "DisplayMenu",
        timeout: 3000,
        display: [b]
    })
end sub
