' ********************************************************************
' **  Roku TV Test App
' ********************************************************************
sub runUserInterface(params As Object)
    ' * Run as Roku Tuning App by default
    ' * If launched with the Service App sequence, launch to adjust persistent
    ' * If launched as side-loaded app, launch with dev permissions
    runas = invalid
    if invalid <> params.source
        if "secret-code" = params.source then
            if invalid <> params.LastKey and ("Up" = params.LastKey or "Select" = params.LastKey) then
                runas = "service"
            end if
        else if "auto-run-dev" = params.source then
            runas = "dev"
        end if
    end if

    if invalid = runas then
        runas = "tuning"
    end if
    getGlobalAA().runlevel = runas
    getApp().run()
end sub