sub initKeycodes(app as Object)
    keycodes = {}
    panelBase = &h7F000000

    ' Roku Remote. All key entries begin with "ROKU"
    keycodes["ROKU_BACK"] = &h00000000
    keycodes["ROKU_HOME"] = &h00000001
    keycodes["ROKU_UP"] = &h00000002
    keycodes["ROKU_DOWN"] = &h00000003
    keycodes["ROKU_LEFT"] = &h00000004
    keycodes["ROKU_RIGHT"] = &h00000005
    keycodes["ROKU_OK"] = &h00000006
    keycodes["ROKU_PLAYPAUSE"] = &h0000000D
    keycodes["ROKU_NETFLIX"] = &h00000013
    keycodes["ROKU_VOL+"] = &h00000018
    keycodes["ROKU_VOL-"] = &h00000019
    keycodes["ROKU_MUTE"] = &h00110001
    keycodes["ROKU_SPLAT"] = &h0000000A
    keycodes["ROKU_REW"] = &h00000008
    keycodes["ROKU_FF"] = &h00000009
    keycodes["ROKU_SOURCE_NEXT"] = &h00110002
    keycodes["ROKU_SOURCE_PREV"] = &h00110019
    keycodes["ROKU_POWER"] = &h00110000
    keycodes["ROKU_M_MODE"] = &h00110011

    ' Aliases
    keycodes["BACK"] = &h00000000
    keycodes["UP"] = &h00000002
    keycodes["DOWN"] = &h00000003
    keycodes["LEFT"] = &h00000004
    keycodes["RIGHT"] = &h00000005
    keycodes["MENU"] = &h00000013
    keycodes["SELECT"] = &h00000006

    lookupTable = {}

    ' Build reverse-lookup table.
    for each keycodeName in keycodes
        if invalid <> keycodes[keycodeName] then
            lookupTable[RokuMfgStrCast(keycodes[keycodeName])] = keycodeName
        end if
    end for

    keycodes.lookupTable = lookupTable
    keycodes.isVolumeKey = isAVolumeKey
    keycodes.lookupName = lookupKeycodeName
    keycodes.simplifyNavigation = simplifyNavigationKeycode

    app.keycodes = keycodes
end sub

function isAVolumeKey(keycode as Integer) as Integer
    keyname = m.lookupName(keycode)
    if "VOL+" = Right(keyname, 4) then
        return 1
    else if "VOL-" = Right(keyname, 4) then
        return -1
    end if
    return 0
end function

function lookupKeycodeName(keycode as Integer) as String
    name = m.lookupTable[RokuMfgStrCast(keycode)]
    if invalid <> name then
        return name
    end if

    return "UNKNOWN"
end function

function simplifyNavigationKeycode(keycode as Integer)
    keyname = m.lookupName(keycode)
    if ("UP" = Right(keyname, 2)) then
        return m["UP"]
    else if ("DOWN" = Right(keyname, 4)) then
        return m["DOWN"]
    else if ("LEFT" = Right(keyname, 4)) then
        return m["LEFT"]
    else if ("BACK" = Right(keyname, 4)) then
        return m["BACK"]
    else if ("RIGHT" = Right(keyname, 5)) then
        return m["RIGHT"]
    else if m["SELECT"] = keycode or m["ROKU_OK"] = keycode or m["CHF_ENTER"] = keycode then
        return m["SELECT"]
    else if "MENU" = Right(keyname, 4) then
        return m["MENU"]
    else if "M_MODE" = Right(keyname, 6) then
        return m["CHF_M_MODE"]
    end if
    return keycode
end function