sub constructAQData(app as object)
    print "initializing data: AQ"

    if app.mfg.aqInfo().count() <> 0 then
        ' using pq versions of these
        app.data.aq = {
            getString   : getAQString
            getNumeric  : getAQNumeric
            getBool     : getAQBool
            set         : setAQSetting
            app         : app
        }

        _json_AQMain = app.mfg.aqinfo()
        initializeAQData(_json_AQMain, app)
    end if

    app.data.constructString({
        id: "AQVersion",
        value: getAQVersion(),
        readonly: true
    })
end sub

function getAQVersion() as String
    aq = RokuMfg().call("aq", {
        action: "get",
        component: "version"
    })

    if RokuMfgCheckResponse(aq) then
        aqversion = ""
        if "" <> aq.data.oem then
            aqversion = aqversion + aq.data.oem + " / "
        end if

        ' Not all platforms return a minor version, but we've always
        ' treated no support as 0. It could also be that the version
        ' entries have been cleared (e.g., model update without reboot).
        ver = {
            minor: "",
            major: "",
            model: ""
        }

        all_empty = true
        for each key in ver
            if "" <> aq.data[key] then
                ver[key] = aq.data[key]
                all_empty = false
            else
                ver[key] = "0"
            end if
        end for

        if all_empty then
            return "Empty (reboot?)"
        else
            return aqversion + ver.major + "." + ver.minor + "." + ver.model
        end if
    end if

    return "Unknown"
end function

sub initializeAQData(data as Object, app as Object)
    app.data.aqtoplevel = []
    app.data.aqstore = []
    parseData(data, app.data.aqtoplevel, app)

    ' AYT: currently no way to retrieve all support sound modes, so will hard coded audio input mode for now
    ' will need to change in a later clean up..
    entry = {
        id          : "AQSoundMode",
        uiid        : "Sound Mode"
        dataset     : ["Normal",
                       "Music",
                       "Speech",
                       "Theater",
                       "Big Bass",
                       "High Treble"]
        onUpdate    : updateEQMode
    }
    currentMode = app.mfg.call("aq", {"action": "get", "component": "eqmode"}).data
    entry.index = RokuMfgIndex(entry.dataset, currentMode)
    param = app.data.constructSelector(entry)
    app.data.get("aq").features.push(param.id)
end sub

function parseData(data as Object, parentArray as Object, app as Object, parent=invalid as Dynamic)
    for each index in data
        p = data[index]
        param = invalid

        if parent <> invalid then
            idname = parent + "/" + p.aqname
        else
            idname = p.aqname
        end if

        canProceed = false
        ret = app.mfg.call("aq", {
            action: "get"
            component: "setting"
            data: {param: idname}
        })
        if p.type <> "object" then
            if RokuMfgCheckResponse(ret) then
                canProceed = true
            end if
        else 
            canProceed = true
        end if

        if canProceed = true then
            if p.type = "readonly" or RokuMfgBoolCast(p.readonly) = true then
                ret = app.mfg.call("aq", {
                    action: "get"
                    component: "setting"
                    data: {param: idname}
                })
                retval = "INVALID"
                if RokuMfgCheckResponse(ret) then
                    if RokuMfgIsAA(ret.data) then
                        retval = ret.data[idname]
                    else
                        retval = ret.data
                    end if
                end if

                param = app.data.constructString({
                    id          : idname
                    aqid        : p.aqname
                    uiid        : p.name
                    value       : retval
                    readOnly    : true
                    order       : strtoi(index)
                })
            else if p.type = "range" then
                aqstep = 1
                if p.step <> invalid then
                    aqstep = p.step
                end if

                param = app.data.constructRange({
                    id          : idname
                    aqid        : p.aqname
                    uiid        : p.name
                    range       : p.range
                    value       : app.data.aq.getNumeric(idname)
                    increment   : aqstep
                    onUpdate    : updateAQFunction
                    order       : strtoi(index)
                    type        : "Float"
                })
            else if p.type = "selector" then
                entry = {
                    id          : idname
                    aqid        : p.aqname
                    uiid        : p.name
                    dataset     : []
                    values      : []
                    onUpdate    : updateAQFunction
                    order       : strtoi(index)
                }

                for each item in p.selector
                    entry.dataset.push(item.name)
                    entry.values.push(item.aqname)
                end for

                ret = app.mfg.call("aq", {
                    action: "get"
                    component: "setting"
                    data: {param: idname}
                })
                if RokuMfgCheckResponse(ret) then
                    if RokuMfgIsAA(ret.data) then
                        retval = ret.data[idname]
                    else
                        retval = ret.data
                    end if

                    entry.index = RokuMfgIndex(entry.values, retval)
                else
                    entry.index = 0
                end if

                param = app.data.constructSelector(entry)
            else if p.type = "boolean" then
                entry = {
                    id          : idname
                    aqid        : p.aqname
                    uiid        : p.name
                    isboolean   : true
                    dataset     : ["False", "True"]
                    values      : [false, true]
                    onUpdate    : updateAQFunction
                    order       : strtoi(index)
                }

                entry.index = RokuMfgIndex(entry.values, app.data.aq.getBool(idname))

                param = app.data.constructSelector(entry)
            else if p.type = "array" then
                param = {
                    app         : app
                    name        : "Array"
                    class_      : "Array"
                    id          : idname
                    aqid        : p.aqname
                    uiid        : p.name
                    features    : []
                    count       : strtoi(p.count)
                    order       : strtoi(index)
                }

                app.data.add(param.id, param)
                aqstep = 1
                if p.step <> invalid then
                    aqstep = p.step
                end if

                for i = 0 to param.count - 1 step 1
                    idx = RokuMfgStrCast(i)
                    cparam = app.data.constructRange({
                        id          : idname + "[" + idx + "]"
                        aqid        : p.aqname + "[" + idx + "]"
                        uiid        : p.name + "[" + idx + "]"
                        range       : p.range
                        value       : app.data.aq.getNumeric(idname + "[" + idx + "]")
                        increment   : aqstep
                        onUpdate    : updateAQFunction
                        order       : i
                    })

                    if cparam <> invalid then
                        param.features.push(cparam.id)
                        app.data.aqstore.push(cparam.id)
                    end if
                end for
            ' AYT: this is unused for now.
            else if p.type = "curve" then
                param = app.data.constructString({
                    id          : p.aqname
                    uiid        : p.name
                    value       : p.default
                    order       : strtoi(index)
                })

                points = p.default.tokenize(",")
                for i = 0 to points.count()-1 step 2
                    rPt = points[i]
                    iPt = points[i]

                    app.data.constructRange({
                        curvename   : p.aqname,
                        id          : p.aqname + "_" + rPt,
                        uiid        : "Reference: " + rPt,
                        range       : p.range,
                        value       : strtoi(iPt),
                        onUpdate    : updateAQCurve
                    })
                end for
            else if p.type = "object" then
                param = {
                    app         : app
                    name        : "Object"
                    class_      : "Object"
                    id          : idname
                    aqid        : p.aqname
                    uiid        : p.name
                    features    : []
                    order       : strtoi(index)
                }

                app.data.add(param.id, param)
                parseData(p["parameters"], param.features, app, idname)
            end if

            if param <> invalid then
                parentArray.push(param.id)
                app.data.aqstore.push(param.id)
            else ' for debugging purposes '
                stop
            end if
        end if
    end for
end function

function updateAQFunction()
    if m.class_ = "Range" then
        value = m.get()
    else if m.class_ = "Selector" then
        value = m.values[m.index]
    end if

    m.app.data.aq.set(m.id, value)

    if not RokuMfgIsString(value)
        value = RokuMfgStrCast(value)
    end if 

    print "Update " + m.id + " to " + value
end function

function updateAQCurve()
    print "needs implementation"
end function

function getAQString(setting as string) as string
    ret = m.app.mfg.call("aq", {
        action: "get",
        component: "setting",
        data: {param: setting}
    })
    if RokuMfgCheckResponse(ret) then
        if RokuMfgIsAA(ret.data) then
            return RokuMfgStrCast(ret.data[setting])
        else
            return RokuMfgStrCast(ret.data)
        end if
    end if
    return ""
end function

' AYT: Currently returns both int and float, and data/Range.brs tolerates whether it's an
' "int range" or a "float range" as per Jimmy's changes.. but this needs to be cleaned-up later.
function getAQNumeric(setting as string)
    data = {}
    data["param"] = setting
    ret = m.app.mfg.call("aq", {
        action: "get",
        component: "setting",
        data: data
    })
    if RokuMfgCheckResponse(ret) 
        return ret.data
    end if
    return 0
end function

function getAQBool(setting as string) as boolean
    data = {"param" : setting}
    ret = m.app.mfg.call("aq", {
        action: "get",
        component: "setting",
        data: data
    })

    if RokuMfgCheckResponse(ret)
        return ret.data
    end if
    return false
end function

sub setAQSetting(setting as string, value as object)
    data = {}
    
    ' AYT: I don't think we need to string-ify this anymore
    'if not m.app.mfg.util.isString(value) then
    '    value = str(value)
    'end if
    data["param"] = setting
    data["value"] = value
    ret = m.app.mfg.call("aq", {
        action: "set"
        component: "setting"
        data: data
    })
    RokuMfgCheckResponse(ret)
end sub

' AYT: This function may be absorbed into the above function, but for now, it is not.. 
' this is just a quick fix kind of deal, will have to clean up later..
function updateEQMode()
    pl = {
        "action": "set",
        "component": "eqmode",
        "data": m.get()
    }
    ret = m.app.mfg.call("aq", pl)

    if not RokuMfgCheckResponse(ret) then
        stop
    end if
    dl = m.app.data.get("aq").features
    reloadAQParameters(dl)
    print "sound mode changed to: " + m.app.mfg.call("aq", {"action":"get", "component":"eqmode"}).data
end function

sub reloadAQParameters(data as Object)
    for each item in data
        param = m.app.data.get(item)

        ' tfranklin: if the param is readOnly, we should skip. It's not going
        ' to change, and it's possible it'll cause the API calls to hiccup.
        if RokuMfgBoolCast(param.readOnly) then
            goto continue
        end if

        if param.class_ = "String" then
            param.value = getAQString(param.id)
        else if param.class_ = "Range" then
            param.value = getAQNumeric(param.id)
        else if param.class_ = "Selector"
            if param.doesExist("isboolean") then
                value = getAQBool(param.id)
            else
                ' AYT: the only selector in AQMain.json that we have at the moment is MS12Config,
                ' which isn't currently hooked to anything so we'll just skip this for now
                goto continue
            end if
            param.index = RokuMfgIndex(param.values, value)
        else if param.class_ = "Array" then
            reloadAQParameters(param.features)
        else if param.class_ = "Object" then
            reloadAQParameters(param.features)
        end if

        continue:
    end for
end sub
