sub initSerialModule(app as Object)
    base = initModuleBase(app)

    o = {
        console: "Serial",
        commandlist: invalid,
        initConsole: SerialConsoleInit,
        destroyConsole: SerialConsoleDestroy,
        send: SerialConsoleSend,
        receiveSting: SerialConsoleReceiveString
    }

    o = RokuMfgMerge(base, o)

    'Init low-level console
    if o.initConsole() = false then
        print "ERROR: Serial module init failed."
        return
    end if

    initCommands(o)
    app.serial = o
    print "Initial Serial Module"
end sub


'
' Used to initialize the low level serial console object
'
' @return true - success, false - fail
function SerialConsoleInit() as Boolean
    ' Check if need to bypass serial for debugging
    key = "DBG_BypassSerial"
    ret = RokuMfg().call("ubapp", {
        action: "get",
        data: key
    })

    if RokuMfgCheckResponse(ret) then
        pc_value = Lcase(ret.data[key])
        for each value in ["1", "y", "yes"]
            if pc_value = value then
                print "DEBUG: serial is disabled for debugging."
                return false
            end if
        end for
    end if

    m.impl = createObject("roUartConsole")
    if RokuMfgIsInvalid(m.impl) then
        print "ERROR: m.impl is invalid!"
        return false
    end if

    m.send("Serial communication established in MFG APP!")

    m.impl.NonCanonical()
    return true
end function

'
' Used to destroy the serial impl object
'
' @return void
sub SerialConsoleDestroy()
    m.impl = invalid
end sub

'
' Used to send the byte array over the serial console
'
' @param data the byte array need to send over serial console.
'
' @return true if all data are sent without problem, otherwise return false
function SerialConsoleSend(data as Object) as Boolean
    if not RokuMfgHasInterface(m.impl, "ifUartConsole") then
        print "Error: uart impl has not been created"
        return false
    end if

    if RokuMfgIsString(data) then
        m.impl.SendOutput(data + Chr(13) + Chr(10))
    else
        if RokuMfgHasInterface(data, "ifByteArray") then
            resp = data
        else if RokuMfgIsArray(data) then
            resp = createObject("roByteArray")
            for i = 0 to data.count()-1
                resp.push(data[i])
            end for
        else
            print "Error: the data to sent is not the correct type"
            return false
        end if

        for each byte in resp
            m.impl.putChar(byte)
        end for
    end if

    return true
end function

' Used to receive a string from the serial console
'
' @return the received string, "" is returned if something wrong
function SerialConsoleReceiveString() as String
    if RokuMfgHasInterface(m.impl, "ifUartConsole") then
        return m.impl.GetInputNonBlocking()
    end if

    return ""
end function