function initModuleBase(app as Object) as Object
    base = {
        app: app,
        started: false, ' Don't accept any serial commands until the serial start command has been given.
        runmode: "String",
        cmd_ok_respond :      "OK",
        cmd_err_respond :     "Error"
        invalid_cmd_respond:  "Invalid",

        buffer: createObject("roString"),
        check: checkSerialInput,
        runCommand: runSerialCommand,
        sendCommand: sendSerialCommand
    }

    return base
end function

'
' Used to check if a valid roByteArray command is received in buffer
' from the command module object.
'
' @return true - run a command, false - not run a command
function checkSerialInput() as Boolean
    m.buffer = m.buffer + m.receiveSting()

    ' Determine if there's a carriage return somewhere in the input, and if so, we have a command to process
    if m.buffer.Instr(Chr(13)) > m.buffer.Instr(Chr(10)) then
        ndx = m.buffer.Instr(Chr(13))
    else
        ndx = m.buffer.Instr(Chr(10))
    end if

    if ndx <> -1 then
        ' We have a command to process
        command = m.buffer.Left(ndx) 'take the command string before "Enter" key, start from ndx
        print "<Function: app.serial.check>:", command

        ' Remove command from buffer
        m.buffer = m.buffer.Mid(ndx+1)

        ' Remove redundant CR or LF
        while m.buffer.Instr(Chr(13)) = 0 or m.buffer.Instr(Chr(10)) = 0
            m.buffer = m.buffer.Mid(1)
        end while

        ' Run this command
        if RokuMfgHasInterface(m.runCommand, "ifFunction") then
            m.runCommand(command)
            return true
        end if
    end if

    return false
end function

sub runSerialCommand(command as String)
    if true = m.started or "ROKU UART ON" = command then
        ' Can't use an associative array index here because we've got to strcmp effectively
        found = false
        for each c in m.commandlist
            if LCASE(command.Left(c.Len())) = LCASE(c) then
                if command.Mid(c.Len(), 1) = " " or command.Len() = c.Len() then
                    entry =  m.commandlist[c]
                    found = true
                    if isCurrentModeOk(m.app, entry.mode) then
                        print "Running Command: ", command
                        commandData = command.Mid(c.Len()).Tokenize(" ")
                        entry.func(commandData, m.app, m)
                    else
                        print "Not allowed TV Working mode: ", command
                    end if
                end if
             end if
        end for
        if not found then
            print "Unrecognized/Unsupported command code: " + command
            m.sendCommand("", "ERROR: Invalid command!")
        end if
    else
        print "serial command has not started"
        m.sendCommand("", "Uart Mode Not Start")
    end if
end sub

sub sendSerialCommand(command as String, response as String)
    if command <> "" then
        str = "RT " + command + " " + response
    else
        str = "RT " + response
    end if

    m.send(str)
end sub

function isCurrentModeOk(app as Object, target as String) as Boolean
    if app.runlevel = "service" then
        return false
    end if

    if target = "ALL" then
        return true
    else if target = "F" and app.data.getValue("ManufacturingMode") = "MFG" then
        return true
    end if

    return false
end function