function SerialCommand(mode, name, func, flag = "")
    return {
        mode: mode,
        name: name,
        func: func,
        flag: flag
    }
end function

' Init command list in this command module (trans_mod)
sub initCommands(trans_mod as Object)
    commands = {
        ' Handshakes
        "ROKU UART":              SerialCommand("ALL", "Enable/Disable Uart Mode",    setUARTcommand), 'FCMD_FACTORY_ON

        ' Dump values
        "ROKU DUMP UB":           SerialCommand("F", "Dump UBAPP Values",             dumpUBAPPAndPCValue, "UB"), ' Dump UB App values
        "ROKU DUMP PC":           SerialCommand("F", "Dump PC Values",                dumpUBAPPAndPCValue, "PC"), ' Dump PC values
        "ROKU DUMP INFO":         SerialCommand("ALL", "Dump System info",            dumpSysInfo), ' Dump System information(Device ID, ESN ...)
        ' Save channel database file
        "ROKU EXPORT CHANNEL_DB": SerialCommand("F", "Export Channel DB File",        exportChannelDBFile),
        "ROKU DUMP CRC":          SerialCommand("ALL", "Dump Partition CRC32",        dumpPartitionCRC32),
    }
    trans_mod.commandlist = commands
end sub

sub unsupportedCommand(data as Object, app as Object, trans_mod as Object)
    app.serial.sendCommand("", app.serial.cmd_err_respond)
end sub

' Enable/Disable UART
sub setUARTcommand(data as Object, app as Object, trans_mod as Object)
    if data[0] = "ON" then
        app.serial.started = true
    else
        app.serial.started = false
    end if

    app.serial.sendCommand("UART", app.serial.cmd_ok_respond)
end sub

' Dump UB App values
sub dumpUBAPPAndPCValue(data as Object, app as Object, trans_mod as Object)
    if m.flag = "UB" then
        'Dump the all important UBAPP settings:
        all_keys = ["guidedsetupdone",
            "mfgmode",
            "mfgprojectidchange",
            "poscopiedfirstboot",
            "posfstype",
            "posinecc",
            "projectid_set_reason",
            "rescuemfgverify",
            "rescueversion",
            "supportnandpos",
            "tvconnected",
            "msu_firmware_update_complete",
            "msu_rescue_reset_complete",
            "msu_rescue_update_complete",
            "partnerbtns"
        ]

        partition = "ubapp"
    else if m.flag = "PC" then
        'Dump the all important UBAPP settings:
        all_keys = ["DEFAULT_LOCALE",
            "ethmac",
            "flag_MODEL_HAS_WIFI_REMOTE",
            "flag_MODEL_SHIPS_WITH_ENHANCED_REMOTE",
            "flag_MODEL_SHIPS_WITH_VOICE_REMOTE",
            "flag_MODEL_HAS_REMOTE_FINDER",
            "GammaTable_UpscaleFactor",
            "hdcp14Key",
            "hdcp22RxKey",
            "manufacturer",
            "odmmodel",
            "panelcalib",
            "panel",
            "projectid",
            "rokumodel",
            "GammaTable_0",
            "GammaTable_1",
            "GammaTable_2",
            "GammaTable_3",
            "GammaTable_Number",
            "mfgdatemonth",
            "mfgdateweek",
            "mfgdateyear",
            "odmesn",
            "odmservice",
            "OriginalODMInfo",
            "brand",
            "supportphone",
            "supporturl",
            "supportphoneca",
            "supportphoneus",
            "supportphonemx",
            "supportphonegb",
            "supportphonebr",
            "supporturlca",
            "supporturlus",
            "supporturlmx",
            "supporturlgb",
            "supporturlbr"
        ]

        partition = "pc"
    else
        print "dumpUBAPPAndPCValue: not invalid command"
        return
    end if

    if RokuMfgIsInvalid(data[0]) or LCase(data[0]) = "all" then
        for each key in all_keys
            ret = RokuMfg().call(partition, {
                action: "get",
                data: key
            })

            if RokuMfgCheckResponse(ret) then
                'print "Dump UBAPP data successfully: " + ret.data[key]
                response = "[" + key +"] = "+ ret.data[key]
                app.serial.sendCommand(m.flag, response)
            else
                print "Dump " + m.flag + " UBAPP data Failed for: " + key
            end if
        end for

    else if data[0] <> "" then
        key = data[0]
        ret = RokuMfg().call(partition, {
            action: "get",
            data: key
        })
        if RokuMfgCheckResponse(ret) then
            'print "Dump UBAPP data successfully: " + ret.data[key]
            response = "[" + key +"] = "+ ret.data[key]
            app.serial.sendCommand(m.flag, response)
        else
            print "Dump data Failed for " + m.flag
            app.serial.sendCommand(m.flag, app.serial.cmd_err_respond)
        end if
    else
        print "Wrong Parameter!"
        app.serial.sendCommand(m.flag, app.serial.invalid_cmd_respond)
    end if
end sub

' Dump Device ID
sub dumpSysInfo(data as Object, app as Object, trans_mod as Object)
    sys_info = Rokumfg().sysInfo()
    for each key in sys_info
        value = sys_info[key]
        if RokuMfgIsString(value) then
            print key + " is: " + value
            app.serial.sendCommand("INFO " + key + " = ", value)
        end if
    end for
end sub

' Save channel database file
sub exportChannelDBFile(data as Object, app as Object, trans_mod as Object)
    name = data[0]
    if name <> invalid then
        ' Copy the current channel database to the USB stick mounted on /media/ext1:/ (mfg mode only)
        ret = app.tv.SaveChannelListFile(name)
        if RokuMfgCheckLegacyResponse("SaveChannelListFile", ret) then
            print "Export Channel Database File Success!"
            app.serial.sendCommand("CHANNEL_DB", app.serial.cmd_ok_respond)
        else
            print "Export Channel Database File Failed!"
            app.serial.sendCommand("CHANNEL_DB", app.serial.cmd_err_respond)
        end if
    else
        print "Wrong Parameter!"
        app.serial.sendCommand("CHANNEL_DB", app.serial.invalid_cmd_respond)
    end if
end sub

' Dump Partition CRC32
sub dumpPartitionCRC32(data as Object, app as Object, trans_mod as Object)
    if RokuMfg().sysInfo().ismsu then
        'For platforms which does not support this feature(Malone, Reno, ...)
        print "Invalid command for this platform"
        app.serial.sendCommand("CRC" , app.serial.invalid_cmd_respond)
        return
    end if

    partitions = ["Active", "Update"]
    for each part in partitions
        ret1 = RokuMfg().call("partitions", {
            action: "gettype",
            data: part
        })
        if RokuMfgCheckResponse(ret1) then
            img_type = ret1.data
        else
            img_type = "Unknown"
        end if

        ret = app.tv.CalcPartitionCRC(part)
        if RokuMfgCheckLegacyResponse("CalcPartitionCRC", ret) then
            crc_value = "0x" + RokuMfgHexCast(ret.crc[0] , 2)  + RokuMfgHexCast(ret.crc[1] , 2) + RokuMfgHexCast(ret.crc[2] , 2) + RokuMfgHexCast(ret.crc[3] , 2)
            app.serial.sendCommand("CRC " + part + "(" + img_type + ") = " , crc_value)
        else
            print "Dump CRC32 value error for " + part + "(" + img_type + ")"
            app.serial.sendCommand("CRC " + part + "(" + img_type + ") = ", app.serial.cmd_err_respond)
        end if
    end for
end sub