'Sub Main( params As Object )

' DESCRIPTION
'     Debug entrypoint.
'
'     Uncomment this function to present this screensaver in the list of channel
'     applications for debugging / testing.
'
' PARAMETERS
'     params - a list of parameters passed by the caller.
'
' RETURNS
'     Void.
'
' NOTES
'     This function should be commented out for actual deployment, as screensavers
'     directly call the RunScreenSaver() entrypoint.

'    params.startedFromMain = true
'    RunScreenSaver( params )

'End Sub


'///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Sub RunScreenSaver( params As Object )

' DESCRIPTION
'     Main screen saver entry point.
'
'     Currently just calls RunBouncingLog() or RunLogoRain() as a screensaver.
'
' PARAMETERS
'     params - a list of parameters passed by the caller.
'
' RETURNS
'     Void.

    rainDisabled = false
    
    ' Check the configuration service to see if the old Bouncing Logo or the newer Logo Rain 
    ' screensaver should be used for the safe-mode screensaver. (Default to using Logo Rain 
    ' if disable flag is not specifically set.)
    '
    cfg = CreateObject( "roConfigService" )
    rainDisabled = cfg.GetBool( "fw.safemode-screensaver.use-old-bouncing-logo", false )
 
    ' Get a string containing any vendors that require the default logo to be displayed.
    ' This is intended as an emergency override in cases where the logo image specified 
    ' in the custom package is incorrect for some reason.
    '
    defaultLogoVendors = cfg.GetString( "fw.safemode-screensaver.default-logo-vendors", "" )
    params.defaultLogoVendors = defaultLogoVendors
    
    ' If the config service says to run the old Bouncing Logo screensaver do so. Otherwise
    ' run the newer Logo Rain screensaver instead.
    ' 
    if rainDisabled
        RunBouncingLogo( params )
    else
        RunLogoRain( params )
    end if

End Sub 
