'///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Function RunBouncingLogo( params As Object )

    bkgdColor = &h010101FF
    logoColor = &hC8C8C8FF

    ' Create a screen object at native resolution for the display.
    screen = CreateObject( "roScreen", true )   
    
    ' Enable alpha blending so that see-through parts of logos will actually be see-through.
    screen.SetAlphaEnable( true )

    ' Save the screen dimensions for later use.
    screenWidth  = screen.GetWidth()
    screenHeight = screen.GetHeight()
    
    ' Define a margin to prevent the logo from being displayed partially off screen.
    screenMargin = screenWidth / 25
   
    ' Load the logo bitmap.
    logoBitmap = GetDeviceLogo()
    
    ' Get some convenient references to the bitmap width and height.
    logoBitmapWidth  = logoBitmap.GetWidth()
    logoBitmapHeight = logoBitmap.GetHeight()
    
    ' Determine how much to scale the logo so that it doesn't occupy more than 10% of the screen.
    logoScale      = ( 0.15*screenWidth ) / logoBitmapWidth 
    logoDrawWidth  = logoScale * logoBitmapWidth
    logoDrawHeight = logoScale * logoBitmapHeight
    
    ' Start the logo in the middle of the screen.
    logoX = ( screenWidth  - logoDrawWidth  ) / 2 
    logoY = ( screenHeight - logoDrawHeight ) / 2 
    
    
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    ''''                                  Main Animation Loop                                  ''''
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    
    while true
    
        ' Clear the screen to black.
        screen.Clear( bkgdColor )
        
        ' Draw the logo in its new position.
        screen.DrawScaledObject( logoX, logoY, logoScale, logoScale, logoBitmap, logoColor )
 
        ' Swap the buffers to display the logo in its new position.
        screen.SwapBuffers()

        ' Snooze for a while, not chewing up CPU in the process.
        Sleep( 6*1000 )       
                      
        ' Determine a new location for the logo.
        logoX = Rnd(0) * (screenWidth  - logoDrawWidth  - 2*screenMargin) + screenMargin
        logoY = Rnd(0) * (screenHeight - logoDrawHeight - 2*screenMargin) + screenMargin
        
    end while 'true

End Function ' RunBouncingLogo( params As Object )


'///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Function GetDeviceLogo()

    ' Get some info about the device.
    dev = CreateObject( "roDeviceInfo" )
    
    ' Determine the screen's aspect ratio.
    aspectRatio = dev.GetDisplayAspectRatio()
    
    ' Determine the device's model and details.
    model   = dev.GetModel()
    details = dev.GetModelDetails()
     
    ' Start by assuming we're going to load the stacked brand logo for the device.   
    logoURL = "brand:/Screensaver-BrandLogo-Stacked"
    
    'mhl devices (Jackson) are a special case. There we want to get the logo from Roku web services.
    if model = "3400X" OR model = "3420X"
        
        mhl = CreateObject( "roMhl" )
        if mhl <> invalid
            mhlAdopterID = mhl.getSinkAdopterIdString()
            mhlDeviceID  = mhl.getSinkDeviceIdString()
        else
            mhlAdopterID = "XXXX" 'for non-mhl devices
            mhlDeviceID  = "XXXX"
        end if
        
        ' Format for remote Logo URL: 
        '    http://assets.roku.com/images/screensavers/<mhlAdopterID>/<mhlDeviceID>/<model>/Logo_<SD_HD>.png
        '
        logoURL = "http://assets.roku.com/images/screensavers/" + mhlAdopterID + "/" + mhlDeviceID + "/" + model + "/Logo"
        
        ' Tack on SD or HD as appropriate for the display's aspect ratio.
        if aspectRatio = "16x9"
            logoURL = logoURL + "_HD.png"
        else
            logoURL = logoURL + "_SD.png"
        end if
             
        ' Download the the logo file into the cache.     
        cachedLogoURL = DownloadCache().get( imageUrl )
        
        ' If we got it, then use the URL as the cached version of the logo.
        if NOT isnullorempty( cachedLocalUrl )
            logoURL = cachedLogoURL
        end if
        
    end if

    ' Try to load a logo image with fallback to other options if we fail.
    logoBitmap = invalid
    while logoURL <> "pkg:/images/DefaultLogo_HD.png"
    
        print "Trying to load logo from "; logoURL
 
        ' Try to load the logo at the current URL. If we succeeded, we're done.
        logoBitmap = CreateObject( "roBitmap", logoURL )
        if logoBitmap <> invalid then exit while
        
        ' Otherwise, a failed stacked brand logo should fall back to a flat logo.
        if logoURL = "brand:/Screensaver-BrandLogo-Stacked"
            logoURL = "brand:/Screensaver-BrandLogo-Flat"

        ' A failed flat brand logo should fall back to the default logo in the package.
        else if logoURL = "brand:/Screensaver-BrandLogo-Flat"
            logoURL = "pkg:/images/DefaultLogo_HD.png"

        ' And a failed remote logo should fall back to a stacked brand logo. 
        else
            logoURL = "brand:/Screensaver-BrandLogo-Stacked"
        endif
    
    end while
        
    ' And return the logo to the caller.
    return logoBitmap
    
End Function ' GetDeviceLogo()
