#!/bin/sh
# DHCP Config Script for BusyBox - Carl Sassenrath, May 2011
# Sets up networking and routing based on DHCP results.
# Used for Paolo's Wifi config.
# Called from: udhcpc -i eth1 -s <script>

[ -z "$1" ] && echo "Run as: udhcpc -i <interface> -s <script>" && exit 1

resolve="/tmp/resolv.conf"

echo "--- Setting up $interface $ip $subnet $router $dns"

case "$1" in
	renew|bound)
		[ -n "$broadcast" ] && bcst="broadcast $broadcast"
		[ -n "$subnet" ] && mask="netmask $subnet"
		echo "--- Configuring $interface for $ip"
		/sbin/ifconfig $interface $ip $bcst $mask

		if [ -n $router ] ; then
			echo "--- Deleting old routes..."
			while route del default gw 0.0.0.0 dev $interface ; do
					:
			done
			for i in $router ; do
				echo "--- Adding route $i"
				route add default gw $i dev $interface
				echo $i >/tmp/gateway
			done
			route -n
		fi

		echo "--- DNS domain: $domain"
		echo "--- DNS server: $dns"

		echo -n > $resolve
		if [ -n "$domain" ] ; then
			echo "domain $domain" >> $resolve
		fi
		for i in $dns ; do
			echo "--- Adding dns: $i"
			echo "nameserver $i" >> $resolve  
		done
		;;

	deconfig)
		ifconfig $interface 0.0.0.0
		;;

esac
exit 0

