#!/bin/sh

# automount an encrypted SD card

# support udev
if [ -z "$MDEV" ]; then
    MDEV=$(basename "$DEVNAME")
fi

# Udev seems to generate events multiple times on boot so use the non-existence of this flag to determine when to actually
# when to execute
if [ ! -z "$UDEV_START" ]; then exit; fi

card_num=$(echo $MDEV | sed 's/^.*\(.\)$/\1/')

if [ "$ACTION" = remove ]; then
    /sbin/sdsetup unmount $card_num > /dev/console &
else
    /sbin/sdsetup mount $card_num > /dev/console &
fi
