'*********************************************************************
'*********************************************************************
Function CreateVoiceRendering(sync = false)
    return { Init : VoiceRendering_Init }.Init(sync)
End Function

'*********************************************************************
'*********************************************************************
Function VoiceRendering_Init(sync)
    m = {}
    m.vr = CreateObject("roVoiceRendering")
    m.prt = CreateObject("roMessagePort")
    m.vr.SetMessagePort(m.prt)
    m.sync = sync

    m.Say           = VoiceRendering_Say
    m.SayNowPlaying = VoiceRendering_SayNowPlaying
    m.SayPhrase     = VoiceRendering_SayPhrase
    return m
End Function

'*********************************************************************
'*********************************************************************
Sub VoiceRendering_Say(phrase, params, flush = true)
    if (m.vr <> invalid ) then
        print "SENDING VR ";phrase;" ";params
        id = m.vr.Say(phrase, params, flush)
        if (m.sync) then
            while (true)
                msg = wait(0,m.vr_prt)
                if (msg = invalid) then
                    exit while
                else if (type(msg) = "roVoiceRenderingEvent") then
                    evt = msg.GetData()
                    id  = msg.GetIndex()
                    if (evt = 1 or evt = 2 and pending_id = id) then
                        exit while
                    end if
                end if
            end while
        end if
    end if
End Sub

'*********************************************************************
'*********************************************************************
Sub VoiceRendering_SayNowPlaying(title, channel_name, flush=false)
    if (m.vr <> invalid ) then
        m.Say("NowPlaying_001", {
                whatsplaying : title,
                channel : channel_name
            })
    end if
End Sub

'*********************************************************************
'params is an associative array of tag:values
'*********************************************************************
Sub VoiceRendering_SayPhrase(tags As String, params As Object)
    if (m.vr <> invalid ) then
        m.Say(tags, params, false)
    end if
End Sub
