' ******************************************************
' Copyright Roku 2011,2012,2013.
' All Rights Reserved
' ******************************************************
REM Functions in this file:
REM     isxmlelement
REM     islist
REM     isarray
REM     isenum
REM     isint
REM     isfunc
REM     isstr
REM     isbool
REM     isfloat
REM     validstr
REM     validint
REM     validlongint
REM     validfloat
REM     validarray
REM     validateParam
REM     

'******************************************************
'isxmlelement
'
'Determine if the given object supports the ifXMLElement interface
'******************************************************
Function isxmlelement(obj as dynamic) As Boolean
    return obj <> invalid and GetInterface(obj, "ifXMLElement") <> invalid
End Function


'******************************************************
'islist
'
'Determine if the given object supports the ifList interface
'******************************************************
Function islist(obj as dynamic) As Boolean
    return obj <> invalid and GetInterface(obj, "ifList") <> invalid
End Function


'******************************************************
'isarray
'
'Determine if the given object supports the ifArray interface
'******************************************************
Function isarray(obj As Dynamic) As Boolean
    return obj <> invalid And GetInterface(obj, "ifArray") <> invalid
End Function


'******************************************************
'isenum
'
'Determine if the given object supports the ifEnum interface
'******************************************************
Function isenum(obj As Dynamic) As Boolean
    return obj <> invalid And GetInterface(obj, "ifEnum") <> invalid
End Function


'******************************************************
'isint
'
'Determine if the given object supports the ifInt interface
'******************************************************
Function isint(obj as dynamic) As Boolean
    return obj <> invalid and GetInterface(obj, "ifInt") <> invalid
End Function


'******************************************************
'isfunc
'
'Determine if the given object supports the ifFunction interface
'******************************************************
Function isfunc(obj as dynamic) As Boolean
    return obj <> invalid and GetInterface(obj, "ifFunction") <> invalid
End Function


'******************************************************
'isstr
'
'Determine if the given object supports the ifString interface
'******************************************************
Function isstr(obj as dynamic) As Boolean
    return obj <> invalid and  GetInterface(obj, "ifString") <> invalid
End Function


'******************************************************
'isbool
'
'Determine if the given object supports the ifBoolean interface
'******************************************************
Function isbool(obj as dynamic) As Boolean
    return obj <> invalid and GetInterface(obj, "ifBoolean") <> invalid
End Function


'******************************************************
'isfloat
'
'Determine if the given object supports the ifFloat interface
'******************************************************
Function isfloat(obj as dynamic) As Boolean
    return obj <> invalid and GetInterface(obj, "ifFloat") <> invalid
End Function


'******************************************************
' validstr
'
' always return a valid string. if the argument is 
' invalid or not a string, return an empty string.
'******************************************************
Function validstr(obj As Object) As String
    if obj <> invalid and GetInterface(obj, "ifString") <> invalid
        return obj
    else
        return ""
    endif
End Function 


'******************************************************
' validint
'
' Always return a valid integer. If the argument is 
' invalid or not an integer, return zero.
'******************************************************
Function validint(obj As Dynamic) As Integer
    if obj <> invalid and GetInterface(obj, "ifInt") <> invalid
        return obj
    else
        return 0
    end if
End Function 

'******************************************************
' validlongint 
'
' supported on frimware version > 7.0 
' Always return a valid long integer. If the argument is 
' invalid or not an integer, return zero.
'******************************************************
Function validlongint(obj As Dynamic) As Integer
    if obj <> invalid and GetInterface(obj, "ifLongInt") <> invalid
        return obj
    else
        return 0
    end if
End Function 

'******************************************************
' validfloat
'
' Always return a valid float. If the argument is 
' invalid or not a float, return zero.
'******************************************************
Function validfloat(obj As Dynamic) As Float
    if obj <> invalid and GetInterface(obj, "ifFloat") <> invalid
        return obj
    else
        return 0
    end if
End Function 

'******************************************************
' validarray
'
' Always return a valid array. If the argument is 
' invalid return [], if it is a singleton wrap it in an
' array, if it is an array return it unmodified.
'******************************************************
Function validarray(obj As Object) As Object
    if obj <> invalid
        if GetInterface(obj, "ifArray") <> invalid
            return obj
        else
            'not an array but not invalid. just wrap as an aray.
            return [obj]
        end if
    else
        return []
    end if
End Function


'******************************************************
'Validate parameter is the correct type
'******************************************************
Function validateParam(param As Object, paramType As String,functionName As String, allowInvalid = false) As Boolean
    if paramType = "roString" or paramType = "String" then
        if type(param) = "roString" or type(param) = "String" then
            return true
        end if
    else if type(param) = paramType then
        return true
    endif

    if allowInvalid = true then
        if type(param) = invalid then
            return true
        endif
    endif

    print "invalid parameter of type "; type(param); " for "; paramType; " in function "; functionName 
    return false
End Function

