' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

sub ShowVolumeSelectionScreen()
    controller = GetBaseViewController("GridView")
    controller.Append({
        scene: m.top
        handlerConfig: {
            HandlerConfigGrid: {
                name: "VolumeSelectionCH"
            }
        }
        overhangOptionStr: Tr("Help & Settings")

        SetUpScreen: VolumeSelection_SetUpScreen
        CleanUp: VolumeSelection_CleanUp
        CloseScreen: VolumeSelection_CloseScreen
        ShowNoConnectionDialog: VolumeSelection_ShowNoConnectionDialog
        ' observers
        OnItemSelected: VolumeSelection_OnItemSelected
        OnGridContentArrived: VolumeSelection_OnGridContentArrived
        OnVolumeChanged: VolumeSelection_OnVolumeChanged
        OnHTTPServersChanged: VolumeSelection_OnHTTPServersChanged
        HandleDialogCloseButton: VolumeSelection_HandleDialogCloseButton
    })
    controller.Observe(controller.view, "rowItemSelected", "OnItemSelected")
    controller.Observe(controller.view, "content", "OnGridContentArrived")
    controller.Observe(controller.scene.httpfs, "activeVolumes", "OnHTTPServersChanged")
    controller.Observe(controller.scene.usb, "volumesChanged", "OnVolumeChanged")
    controller.Observe(controller.scene.dlna, "volumesChanged", "OnVolumeChanged")

    controller.SetUpScreen()
    controller.view.theme = {
            OverhangOptionsText: controller.overhangOptionStr
        }
    controller.view.updateTheme = {OverhangTitle: Tr("Select Media Device")}

    ShowNewView(controller.view)
end sub

sub VolumeSelection_SetUpScreen()
    ' RMP-518: VS screen sometimes get volume change event when view already closed
    ' check if view is valid to avoid crashes
    if m.view <> invalid
        content = CreateObject("roSGNode", "ContentNode")
        content.Update(m.handlerConfig, true)
        m.view.id = "vsscreen"
        m.view.style = "rmp"
        m.view.posterShape = "square"
        m.view.content = content
    end if
end sub

' will be called when view was closed
sub VolumeSelection_CleanUp()
    m.scene = invalid
end sub

sub VolumeSelection_CloseScreen()
    m.view.close = true
end sub

sub VolumeSelection_ShowNoConnectionDialog()
    currVolume = GetGlobalAA().lastMediaServer
    if currVolume <> invalid and currVolume.accessType <> USBAccessType() then
        dialogMsg = Substitute(tr("Not able to connect to {0} please check your connection."), currVolume.title)
    else
        dialogMsg = tr("USB device ") + currVolume.title + tr(" is no longer available, please choose another source.")
    end if
    dialog = ShowInformationDialog(dialogMsg)
    RSGCallback_RegisterNodeCallback(dialog, "buttonSelected", m, "HandleDialogCloseButton")
end sub

sub VolumeSelection_OnItemSelected(gridView as Object, rowItemSelected as Object)
    itemSelected = GetGridItem(gridView.content, rowItemSelected)
    if itemSelected <> invalid
        ' mediaServer = itemSelected.Clone(false)
        
        ' make sure to clear search string as this might get cached from previous search requests
        fs = itemSelected.fs
        if fs <> invalid
            fs.searchStr = ""
            itemSelected.fs = fs
        end if
        
        mediaServer = itemSelected
        ShowContentScreen(GetRootObjectID(), mediaServer, mediaServer)
    end if
end sub

sub VolumeSelection_OnGridContentArrived(gridView as Object, content as Object)
    ' check if there is any media server
    ' if no -> show help paragraph screen
    if content <> invalid and content.failedLoading = true
        m.CloseScreen()
        ShowHelpScreen("connect_media_server")
    else if content <> invalid and content.failedLoading = false
        launchVolume = Config().Get("launchVolume")
        if launchVolume <> invalid
            Config().AddSet("launchVolume", invalid)
            Config().UpdateLocal()
            for i = 0 to content.GetChild(0).GetChildCount() - 1
                volume = content.GetChild(0).GetChild(i)
                if volume.usn = launchVolume
                    if Config().Get("AudioOnly")
                        PlayVolume(volume)
                    else
                        m.OnItemSelected(m.view, [0, i])
                    end if
                    exit for
                end if
            end for
        end if
    end if
end sub

sub VolumeSelection_OnVolumeChanged(service as Object, isChanged as Boolean)
    lastMediaServer = GetGlobalAA().lastMediaServer
    if lastMediaServer <> invalid and lastMediaServer.accessType = service.accessType
        deviceRemoved = true
        for each volume in service.activeVolumes
            if volume.usn = lastMediaServer.usn
                deviceRemoved = false
                exit for
            end if
        end for
        if deviceRemoved
            if not m.view.IsInFocusChain()
                ' We are passing "false" here, because we shouldn't access scene in the function,
                ' especially when screensaver will be shown
                CloseAllViewsTillID(m.view.id, false)
                m.ShowNoConnectionDialog()
            end if
        end if
    end if
    ' reload content if devices have been removed or added new
    m.SetUpScreen()
end sub

sub VolumeSelection_OnHTTPServersChanged(service as Object, volumes as Object)
    ' reload the content
    m.SetUpScreen()
end sub

sub VolumeSelection_HandleDialogCloseButton(dialog as Object, buttonSelected as Integer)
    dialog.close = true
end sub
