' ********** Copyright 2020 Roku Corp. All Rights Reserved. **********

sub ShowVolumeInfo()
    controller = GetBaseViewController("ParagraphView")
    controller.Append({
        SetUpScreen: VolumeInfoScreen_SetUpScreen
        ShowScanningFacade: VolumeInfoScreen_ShowScanningFacade
        OnButtonSelected: VolumeInfoScreen_OnButtonSelected
        OnKeyboardEntered: VolumeInfoScreen_OnKeyboardEntered
        OnActiveVolumesChanged: VolumeInfoScreen_OnActiveVolumesChanged
        OnScanningFacadeClosed: VolumeInfoScreen_OnScanningFacadeClosed
    })
    controller.Observe(controller.view, "buttonSelected", "OnButtonSelected")

    controller.SetUpScreen()
    ShowNewView(controller.view)
end sub

sub VolumeInfoScreen_SetUpScreen()
    currView = GetCurrentView()
    if m.volume = invalid
        m.volume = GetGridItem(currView.content, currView.rowItemFocused)
    end if
    if m.volume <> invalid
        buttonsContent = CreateObject("roSGNode", "ContentNode")
        prvdr = m.volume.provider
        isFav = prvdr.USN = GetDLNAFavorite()
        buttons = []
        title = m.volume.title
        t = ""
        if m.volume.accesstype <> USBAccessType()  ' dlna
            if prvdr.modelDescription <> invalid
                t = prvdr.modelDescription
            end if
            if t = "" and prvdr.modelName <> invalid
                t = prvdr.modelName
            endif
            t = t + CHR(10) + prvdr.location
            if m.volume.accesstype = DLNAAccessType()
                buttons.Push({title: tr("Change USERAGENT"), id: "user_agent"})
                if isFav
                    t = t + CHR(10) + tr("Favorite")
                    buttons.Push({title: tr("Clear Favorite DLNA server"), id: "clear_dlna_fav"})
                else
                    buttons.Push({title: tr("Set Favorite DLNA server"), id: "set_dlna_fav"})
                end if
                ua = computeUserAgent(prvdr)
                t = t + CHR(10) + "USERAGENT:" + ua
            endif
            buttons.Push({title: tr("Close"), id: "close"})
            buttonsContent.Update({children: buttons})
        else
            vi = m.volume.volumeInfo
            print vi
            t = t + tr("Total Blocks: ") + vi.blocks.tostr() + tr(" Used: ") + vi.usedblocks.tostr() + tr(" Free: ")+vi.freeblocks.tostr()
            dt = CreateObject("roDateTime")
            dt.FromSeconds(m.volume.volumeInfo.mountTime)
            t = t + CHR(10) + tr("Mount Time: ") + dt.ToISOString()
            ' We should exclude those buttons for USB only version of RMP
            if isUSBOnly() = false
                if m.volume.fs.hasfullcache = true
                    buttons.Push({title: tr("Clear USB Cache"), id: "clear_cache"})
                else
                    buttons.Push({title: tr("Scan"), id: "scan"})
                end if
            end if
            buttons.Push({title: tr("Close"), id: "close"})
            buttonsContent.Update({children: buttons})
        endif
        if prvdr.searchable = true
            t = t + CHR(10) + tr("Searchable")
        endif
        content = CreateObject("roSGNode", "ContentNode")
        content.Update({
            children: [{
                paragraphType: "header"
                text: title
            },{
                text: t
            }]
        }, true)
        m.view.buttons = buttonsContent
        m.view.content = content
    end if
    m.view.theme = { OverhangShowOptions: false }
    m.SetOverhangTitle(Tr("Volume Info"))
end sub

sub VolumeInfoScreen_ShowScanningFacade()
    if m.scanningFacade = invalid
        m.scanningFacade = CreateObject("roSGNode", "SGDEXComponent")
        m.scanningFacade.theme = { OverhangShowOptions: false }
        facadeComponent = m.scanningFacade.CreateChild("LoadingFacade")
        facadeComponent.bEatKeyEvents = false
        facadeComponent.busySpinner.id = "spinner"
        m.scanningFacade.Update({
            children: [{
                subtype: "Label"
                translation: [0, 450]
                width: 1280
                numLines: 1
                horizAlign: "center"
                text: tr("Scanning Media. Please wait...")
            }]
        })
        m.scanningFacade.theme = { OverhangShowOptions: false }
        m.Observe(m.scanningFacade, "wasClosed", "OnScanningFacadeClosed")
        ShowNewView(m.scanningFacade)
    end if
end sub

sub VolumeInfoScreen_OnButtonSelected(view as Object, buttonSelected as Integer)
    selectedButton = view.buttons.GetChild(buttonSelected)
    if selectedButton <> invalid
        if selectedButton.id = "scan"
            usb = m.view.GetScene().usb
            usb.scan = true
            m.Observe(usb, "activeVolumes", "OnActiveVolumesChanged")
            m.ShowScanningFacade()
        else if selectedButton.id = "clear_cache"
            m.view.GetScene().usb.clearCache = true
            fs =  m.volume.fs
            fs.hasFullCache = false
            m.volume.fs = fs
            m.SetUpScreen()
        else if selectedButton.id = "set_dlna_fav"
            SaveDLNAFavorite(m.volume.usn)
            m.SetUpScreen()
        else if selectedButton.id = "clear_dlna_fav"
            SaveDLNAFavorite("")
            m.SetUpScreen()
        else if selectedButton.id = "user_agent"
            keyboard = CreateObject("roSGNode", "KeyboardDialog")
            keyboard.text = computeUserAgent(m.volume.provider)
            keyboard.buttons = [tr("Finished")]
            keyboard.title = tr("USERAGENT")
            m.Observe(keyboard, "buttonSelected", "OnKeyboardEntered")
            m.view.GetScene().dialog = keyboard
        else if selectedButton.id = "close"
            m.view.close = true
        end if
    end if
end sub

sub VolumeInfoScreen_OnKeyboardEntered(keyboardDialog as Object, buttonSelected as Integer)
    provider = m.volume.provider
    if keyboardDialog.text <> computeUserAgent(provider)
        newua = keyboardDialog.text
        provider.UserAgentHeader = newua
        userAgents = Config().Get("UserAgents")
        userAgents[provider.USN] = newua
        Config().AddSet("userAgents", userAgents)
        Config().UpdateLocal()
        m.volume.provider = provider
        SaveUserAgents()
        m.SetUpScreen()
    end if
    keyboardDialog.close = true
end sub

sub VolumeInfoScreen_OnActiveVolumesChanged(usb as Object, activeVolumes as Object)
    if m.scanningFacade <> invalid
        m.scanningFacade.close = true
        m.scanningFacade = invalid
    end if
    for each volume in activeVolumes
        if volume.usn = m.volume.usn
            m.Unobserve(usb, "activeVolumes")
            m.volume.fs = volume.fs
            m.SetUpScreen()
            exit for
        end if
    end for
end sub

sub VolumeInfoScreen_OnScanningFacadeClosed(facade as Object, wasClosed as Boolean)
    if facade.close = false
        ' user close facade so we need to cancel scanning
        usb = m.view.GetScene().usb
        usb.cancel = true
        m.Unobserve(usb, "activeVolumes")
    end if
    m.Unobserve(facade, "wasClosed")
    m.scanningFacade = invalid
end sub