' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

' function for building base view controller
' mainly used to have unified interface for all controllers
' @Params: viewName - name of the view that should be created
' @Return value: base controller AA
function GetBaseViewController(viewName as String) as Object
    baseController = {
        view: CreateObject("roSGNode", viewName)
        _observedObjects: []

        SetOverhangTitle: ViewController_SetOverhangTitle
        Observe: ViewController_Observe
        Unobserve: ViewController_Unobserve
        OnWasClosed: ViewController_OnViewWasClosed
    }
    RSGCallback_RegisterNodeCallback(baseController.view, "wasClosed", baseController, "OnWasClosed")
    return baseController
end function

sub ViewController_SetOverhangTitle(title = "" as String)
    overhangTtitle = Tr("Media Player")
    if title <> ""
        overhangTtitle = overhangTtitle + " | " + title
    end if
    m.view.updateTheme = {OverhangTitle: overhangTtitle}
end sub

sub ViewController_Observe(node as Object, field as String, functionName as String)
    RSGCallback_RegisterNodeCallback(node, field, m, functionName)
    m._observedObjects.Push({
        node: node
        field: field
    })
end sub

sub ViewController_Unobserve(node as Object, field as String)
    for i = 0 to m._observedObjects.Count() - 1
        observedObj = m._observedObjects[i]
        if (observedObj.node.field = field) and observedObj.node.IsSameNode(node)
            RSGCallback_RemoveNodeCallback(observedObj.node, observedObj.field)
            m._observedObjects.Delete(i)
            exit for
        end if
    end for
end sub

sub ViewController_OnViewWasClosed(view as Object, wasClosed as Boolean)
    if wasClosed = true
        ' unobserve all fields to avoid memory leaks
        while m._observedObjects.Count() > 0
            observedObj = m._observedObjects.Pop()
            RSGCallback_RemoveNodeCallback(observedObj.node, observedObj.field)
            observedObj.node = invalid
        end while
        if m["CleanUp"] <> invalid then m["CleanUp"]()
        m.view = invalid
    end if
end sub
