' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

function NewUSBController() as Object
    return {
        task: m.top
        port: CreateObject("roMessagePort")
        rofs: CreateObject("roFileSystem")
        imageMetaData: CreateObject("roImageMetadata")
        audioMetaData: CreateObject("roAudioMetadata")
        byteReader: CreateObject("roByteArray")
        volumes: [] ' Actual MediaServers

        Init: USB_Init
        GetMimeTypes: USB_GetMimeTypes
        ClearAutorunFlags: USB_ClearAutorunFlags
        HeaderCompare: USB_HeaderCompare
        HandleEvent: USB_HandleEvent
        UpdateValidVolumes: USB_UpdateValidVolumes
        GetCurrentMSList: USB_GetCurrentMediaServerList
        GetVolumeList: USB_GetCurrentMediaServerList
    }
end function

sub USB_Init()
    m.mimetypes = m.GetMimeTypes()
    ' compute regex for all audio extensions
    allFilesRegex = box("\.(")
    vertbar = ""
    for each ex in m.mimetypes
        if m.mimetypes[ex].type = 2
            j = ex.len()
            if j <= 6 ' avoids x_autodetect
                allFilesRegex.AppendString(vertbar+ex.right(j-2),100)
                vertbar = "|"
            end if
        end if
    end for
    allFilesRegex.AppendString(")$",2)
    print "allFilesRegex=";allFilesRegex
    m.allFilesRegex = allFilesRegex

    m.cacheRoot = "tmp:"
    m.cacheFSPath = "tmp:/rmp-usb-cache"
    m.fullCacheFSPath = "tmp:/full-rmp-usb-cache"
    if hasCacheFS()
        m.cacheRoot = "cachefs:"
        m.cachefspath = "cachefs:/rmp-usb-cache"
        m.fullcachefspath = "cachefs:/full-rmp-usb-cache"
    end if

    m.albumartroot = "cachefs:/albumroot"

    ' set up observers to handle file system events
    m.rofs.SetMessagePort(m.port)
    m.UpdateValidVolumes()
end sub

function USB_GetMimeTypes() as Object
    ' common values
    mp4 = { type: 1, format: "mp4", name: "mp4" }
    ts = { type: 1, format: "ts" , name: "ts" }
    jpg = { type: 3, format: "jpg", name: "jpg" }

    mimetypes = { 'map known extensions to pseudo-mime-type here
        x_3g2: mp4
        x_3gp: mp4
        x_m4v: mp4
        x_mp4: mp4
        x_lrv: mp4
        x_mov: mp4
        x_mkv: { type: 1, format: "mkv", name: "mkv" }
        x_ts:  ts
        x_m2ts:ts
        x_trp: ts
        x_mts: ts
        x_m4a: { type: 2, format: "mp4", name: "mp4" }
        x_mp3: { type: 2, format: "mp3", name: "mp3" }
        x_mp2: { type: 2, format: "mp3", name: "mp2" }
        x_wma: { type: 2, format: "wma", name: "wma" }
        x_mka: { type: 2, format: "mka", name: "mka" }
        x_jpg: jpg
        x_thm: { type: 3, format: "jpg", name: "thm" }
       x_jpeg: jpg
        x_png: { type: 3, format: "png", name: "png" }
        x_gif: { type: 3, format: "gif", name: "gif" }
        'Anything else belongs in the "other" category
    }
    if hasAutoDetect()
        mimetypes.x_autodetect = { type: 1, format: "", name: "autodetect" }
    end if
    if allowPlaylists()
        mimetypes.x_m3u8 = { type: 0, format: "hls", name: "hls" }
        mimetypes.x_m3u = mimetypes.x_m3u8
        mimetypes.x_pls = { type: 0, format: "pls", name: "pls" }
    else
        mimetypes.x_m3u8 = { type: 1, format: "hls", name: "hls" }
    end if
    if hasVP9()
        mimetypes.x_webm = { type: 1, format: "mkv", name: "mkv" }
    end if
    if hasPCM()
        t = { type: 2, format: "pcm", name: "pcm" }
        mimetypes.x_aif = t
        mimetypes.x_aiff = t
        mimetypes.x_aifc = t
        mimetypes.x_au  = t
        mimetypes.x_wav = t
        mimetypes.x_wave = t
    end if
    if hasFlac()
        mimetypes.x_flac = { type: 2, format: "flac", name: "flac" }
    end if
    if hasAlac()
        mimetypes.x_alac = { type: 2, format: "mp4", name: "mp4" }
    end if
    if hasOgg()
        t = { type: 2, format: "ogg", name: "ogg" }
        mimetypes.x_ogg = t
        mimetypes.x_oga = t
        mimetypes.x_opus = t
    end if
    if hasFLV()
        mimetypes.x_flv = { type: 1, format: "flv", name: "flv" }
    endif
    if hasASF()
        mimetypes.x_asf = { type: 1, format: "asf", name: "asf" }
    endif
    if hasAac()
        mimetypes.x_aac = { type: 2, format: "es.aac-adts", name: "aac" }
    end if
    if hasAc3()
        mimetypes.x_ac3 = { type: 2, format: "ac3", name: "ac3" }
    end if
    if hasEAc3()
        mimetypes.x_eac3 = { type: 2, format: "ac3", name: "eac3" }
    end if
    if  hasWMV()
        mimetypes.x_wmv = { type: 1, format: "wmv", name: "wmv" }
    end if
    if hasMAT()
        mimetypes.x_mat = { type: 2, format: "mat", name: "mat" }
    endif
    if hasAC4()
        mimetypes.x_ac4 = { type: 2, format: "ac4", name: "ac4" }
    endif

    'this.mimetypes.x_mpd = { type: 1, format: "dash", name: "dash" }

    return mimetypes
end function

function USB_HandleEvent(msg as Object) as Boolean
    if msg <> invalid
        if type(msg) = "roFilesystemEvent"
            if msg.isStorageDeviceRemoved()
                print "!!!!!!!!!!!!!USB: storage device removed!!!!!!!!!!!!!!!!!!"
            end if
            m.UpdateValidVolumes()
            m.task.volumesChanged = true
            return true
        else if type(msg) = "roSGNodeEvent"
            field = LCase(msg.getField())
            if field = "getdirectorylisting"
                request = msg.GetData()
                mediaServer = request.mediaserver
                for each volume in m.volumes
                    if volume.usn = mediaServer.usn
                        m.task.returnDirectoryListing = volume.fs.getDirectoryListing(request.objId, request.searchStr)
                        exit for
                    end if
                end for
            else if field = "getsearchcapabilities"
                request = msg.GetData()
                mediaServer = request.mediaserver
                for each volume in m.volumes
                    if volume.usn = mediaServer.usn
                        m.task.searchCapabilities = volume.fs.getSearchCapabilities()
                        exit for
                    end if
                end for
            else if field = "scan"
                for each volume in m.volumes
                    volume.fs.scanCache()
                end for
                m.UpdateValidVolumes()
            else if field = "clearcache"
                for each volume in m.volumes
                    volume.fs.ClearCache()
                end for
                m.UpdateValidVolumes()
            else if field = "clearautorun"
                m.ClearAutorunFlags()
            end if
        end if
    end if
end function

function usbptr()
    return GetGlobalAA().USBController
end function

function nullVolumes()
    return []
end function

function USB_UpdateValidVolumes()
    print "USB_UpdateValidVolumes"
    newVols = []
    currentVolumeList = m.rofs.GetVolumeList()

    ' remove volumes no longer in the list
    print "removing volumes from usb list"
    i = 0
    for each volume in m.volumes
        deleteIt = true
        for each nvol in currentVolumeList
            print "checking vol=";volume.usn;" with ";nvol
            if nvol = volume.usn
                print "found it - don't delete it"
                deleteIt = false
                exit for
            end if
            ' not found
        end for
        if deleteIt
            volumeToDelete = m.volumes[i]
            volumeToDelete.fs.ClearCache()
            m.volumes.Delete(i)
        else
            i++
        end if
    end for

    for each volume in currentVolumeList
        volumeInfo = m.rofs.GetVolumeInfo(volume + "/")
        'print "+++VOLUME INFO+++[";volume;"]"
        'PrintAA(volumeInfo)
        'print "+++++++++++++++++"
        if (volumeInfo <> invalid) and (InStr(1, volume, "ext") = 1)
            newVolume = {}
            if volumeInfo.label <> invalid and volumeInfo.label <> ""
                newVolume.label = ValidStr(volumeInfo.label)
            else
                if volumeInfo.uuid <> invalid and volumeInfo.uuid <> ""
                    newVolume.label = newvolume.uuid
                else
                    newVolume.label = volume
                end if
            end if
            ' is this an existing volume in the list?
            isNewVol = true
            for each ovol in m.volumes
                if (ovol.usn = volume)
                    isNewVol = false
                    exit for
                end if
            end for
            ' also ignore some system volume names
            if isNewVol and (newVolume.label <> "EFI") and (newVolume.label <> "Recovery HD")
                ' make sure there is something in the top level, if not ignore it
                path = CreateObject("roPath", volume + "/") ' volume + "/"
                listing = m.rofs.GetDirectoryListing(path)
                if listing.Count() > 0
                    newVolume.posterUrl = USBUtilGetVolumePoster(m, volume)
                    newVolume.ShortDescriptionLine2 = volume '+ "/"
                    newVolume.shortDescriptionLine1 = newVolume.label
                    if newVolume.shortDescriptionLine1 = ""
                        newVolume.shortDescriptionLine1 = " "
                    end if
                    newVolume.volumeInfo = volumeInfo
                    ' create USN - this is just the mount point
                    newVolume.usn = volume
                    newVolume.uuid = usbUUID(volumeInfo) ' this is used by meta data cache
                    newVolume.accessType = USBAccessType()
                    newVolume.provider = CreateProvider( { location: volume } )
                    if isUSBOnly()
                        newVolume.provider.searchable = false
                    endif
                    fs = usb_createFS(newVolume) ' create fs access functions
                    fs.hasAutorunfile = false
                    fs.volumeInfo = volumeInfo ' need a copy of that here also
                    fs.uuid = newvolume.uuid
                    ' update cache flag
                    fs.CacheExists(false)

                    if not autorunDisabled()
                      for each filename in listing
                        if filename = "Autorun.m3u"
                            fs.hasAutorunfile = true
                            exit for
                        end if
                      end for
                    end if
                    newvolume.fs = fs
                    print "new usb volume - ";volume
                    newVols.Push(newVolume)
                end if
            end if
        end if
    end for
    m.volumes.append(newVols)
    m.task.activeVolumes = m.volumes
end function

function usb_GetCurrentMediaServerList()
    return m.volumes
end function
