' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

sub init()
    m.top.accessType = USBAccessType()
    StartBackgroundThread()
end sub

sub StartBackgroundThread()
    m.top.functionName = "ServiceMain"
    m.top.control = "run"
end sub

sub ServiceMain()
    m.lastFM = NWM_LastFM("86878d14ffd65230bcc7937a96db3976", "b082b0aeda1c485ec31c24d833e1ec64")
    m.USBController = NewUSBController()
    m.USBController.Init()

    tmout = 5000
    port = m.USBController.port
    m.top.ObserveField("getDirectoryListing", port)
    m.top.ObserveField("getSearchCapabilities", port)
    m.top.ObserveField("clearAutoRun", port)
    m.top.ObserveField("scan", port)
    m.top.ObserveField("clearCache", port)
    m.top.ObserveField("cancel", port)
    m.top.initialized = true
    while true
        msg = wait(tmout, port)
        m.USBController.HandleEvent(msg)
    end while
end sub
