' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

function createProvider(fields as object) as object
    print "CreateProvider fields ============"
    print fields
    print "======================="
    fields.new = true
    fields.deleted = false
    fields.nodetype = "provider"
    fields.changed = false
    fields.miniDLNA = false
    fields.Twonky = false
    fields.Plex = false
    fields.Windows10 = false
    fields.mezzmo = false
    fields.UserAgentHeader = ""
    fields.Searchable = true
    evaluateProvider(fields)

    return fields
end function

function evaluateProvider(provider)
    if provider.SERVER <> invalid
REM    SERVER: "4.1.6-100.fc21.x86_64 DLNADOC/1.50 UPnP/1.0 MiniDLNA/1.1.5"
       if provider.server.instr("MiniDLNA") >= 0
           provider.miniDLNA = true
       else if provider.server.instr("Twonky") >= 0
           provider.Twonky = true
       else if provider.server = "Microsoft-Windows/10.0 UPnP/1.0 UPnP-Device-Host/1.0"
           provider.Windows10 = true
       else if provider.server.instr("Mezzmo") >= 0
           provider.mezzmo = true
           provider.UserAgentHeader = "Roku/DVP"
       else if provider.server.instr("Platinum") >= 0
           provider.Searchable = false
       else if provider.server.instr("Serviio") >= 0
           provider.Searchable = false
           'provider.UserAgentHeader = "CHANERU"
       endif
       ua = Config().Get("userAgents")[provider.USN]
       if ua <> invalid and ua <> ""
           provider.UserAgentHeader = ua
       endif
    endif
end function

function locationRoot(location as string) as string
    locRoot = invalid
    len = location.instr("http://")  ' make sure http:// is the first part of the location string
    if len = 0
        len = location.len()
        ip = location.right(len-7)   ' strip off http://
        len = ip.instr("/")
        if len>0
            locRoot = ip.left(len)  ' we only want ipaddress:portnum
        else
            locRoot = ip
        endif
    else
        print "ERROR bad location:";location
    endif
    return locRoot
end function

function service_GetProgressLabel(spinner as Object) as Object
    label = spinner.FindNode("progressLabel")

    if label = invalid
        layoutGroup = spinner.CreateChild("LayoutGroup")
        layoutGroup.id = "layout"

        label = layoutGroup.CreateChild("Label")
        label.id = "progressLabel"
        label.horizAlign = "center"
        label.vertAlign = "center"
        label.width = spinner.poster.bitmapWidth
        label.height = spinner.poster.bitmapHeight
    end if

    return label
end function

sub RemoveLabel(spinner as Object)
    layout = spinner.FindNode("layout")

    if layout <> invalid
        spinner.RemoveChild(layout)
    end if
end sub

sub service_UpdateProgress(progress as Float)
    gthis = GetGlobalAA()
    if gthis.top.progressEnabled = false
        return
    end if
    ' we should show progress indicator only if spinner is visible more than 1s
    if m.timespan <> invalid and m.timespan.TotalMilliseconds() < 1000
        return
    end if
    if progress >= 0.0 and progress < 1.0
        ' put the progress to the current view's busy indicator (spinner)
        if m.spinner <> invalid
            label = m.GetProgressLabel(m.spinner)
            labelText = int(progress * 100).ToStr() + "%"
            label.text = labelText
        end if
    else if m.spinner <> invalid
        RemoveLabel(m.spinner)
    end if
end sub
