' ********** Copyright 2020 Roku Corp. All Rights Reserved. **********

function NewHTTPFSController()
    return {
        task: m.top
        httpvols: []
        volumes: []
        providers: {}

        Init: HttpFS_Init
        HandleEvent: HttpFS_EventHandler
        GetValidVolumes: HttpFS_GetValidVolumes
        GetCurrentMSList: HttpFS_GetCurrentMediaServerList
        getVolumeList: HttpFS_GetMediaServerList
        clearServerList: HttpFS_ClearServers
        GetURL: HttpFS_GetUrl
        GetUrlDir: HttpFS_GetUrlDir
        AddHTTPFileServer: HttpFS_AddHTTPFileServer
    }
end function

sub HttpFS_Init()
    print "InitHttpFS now----------------------------------------------"
    SetRokuTestMediaEnabled(true)

    if Config().IsTrue("useSharedHttpServers")
        m.httpvols.push(MakeHTTPFileServer("qa-mediaserver", "http://qa-mediaserver.corp.roku/media/"))
        m.httpvols.push(MakeHTTPFileServer("xnet-qts(dlna1)", "http://10.11.108.89/media"))

'                     location:  "http://qa-webstream.corp.roku/media"
        'm.httpvols.push(MakeHTTPFileServer("qa-webstream", "http://10.11.108.60/media"))
'                     location:  "http://dev-webstream.corp.roku/media"
'                     location:  "http://qa-mediaserver.corp.roku/media"
        'm.httpvols.push(MakeHTTPFileServer("qa-mediaserver", "http://10.11.108.115/media"))
'                     location:  "http://qa-mediaserver.corp.roku/media"
'        this.httpvols.push(MakeHTTPFileServer("dluck-xi", "http://dluck-xi.corp.roku/test"))
    end if

    m.getVolumeList()
end sub

function HttpFS_EventHandler(msg As Object) As Boolean
    if type(msg) = "roSGNodeEvent"
        field = LCase(msg.getField())
        if field = "getdirectorylisting"
            request = msg.GetData()
            mediaServer = request.mediaserver
            for each volume in m.volumes
                if volume.usn = mediaServer.usn
                    m.task.returnDirectoryListing = volume.fs.getDirectoryListing(request.objId, request.searchStr)
                    exit for
                end if
            end for
        else if field = "addserver"
            serverUrl = msg.GetData()
            name = serverUrl.Right(Len(serverUrl) - 7)
            m.AddHTTPFileServer(name, serverUrl)
        end if
    end if
    return false
end function

function httpfsptr()
    return m.httpfsController
end function

function enableRokuTestMedia(enabled as boolean) as void
    this = httpfsptr()
    for each vol in this.httpvols
        if vol.RokuTM
            vol.enabled = enabled
        endif
    next
    this.getVolumeList()
end function

function MakeHTTPFileServer(name as string, location as string)
    vol = {
        name:       name
        modelDescription: "HTTP File Server"
        location:   location
        RokuTM:     false           ' test media off
        enabled:    true
    }
    return vol
end function

function HttpFS_AddHTTPFileServer(name as string, location as string)
    found = false
    for each vol in m.httpvols
        if (vol.name = name) and (vol.location = location)
            print "HTTPVol already in list"
            found = true
        end if
    end for
    if not found
        vol = MakeHTTPFileServer(name, location)
        toplevelcontents = m.GetUrlDir(vol.location, true)
        if toplevelcontents.count() > 0
            print "adding ";name;" at ";location;" to httpFS"
            m.httpvols.push(vol)
            m.volumes = m.getvalidvolumes()
        end if
    end if
end function

function HttpFS_ClearServers()
    print "HttpFS_ClearServers   clearing............."
        for each usn in m.providers
            provider = m.providers[usn]
            provider.deleted = true
            provider.changed = true
        end for
        m.volumes = []
end function

function HttpFS_GetMediaServerList()
    print "HttpFS_GetMediaServerList!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
    m.volumes = m.GetValidVolumes()
    return m.volumes
end function

function HttpFS_GetCurrentMediaServerList()
    return m.volumes
end function

function HttpFS_GetValidVolumes()
    result = []
    print "HttpFS_GetValidVolumes"

    for each vol in m.httpvols
      if vol.enabled
        print "Trying FS at : ";vol.location
        toplevelcontents = m.GetUrlDir(vol.location, true)
        if toplevelcontents.count() > 0
            newVolume = {}
            newVolume.label = vol.name

            newVolume.ShortDescriptionLine2 = vol.location
            newVolume.shortDescriptionLine1 = newVolume.label

            ' create USN
            usn = vol.location
            newVolume.usn = usn
            newVolume.accessType = HTTPAccessType()
            newVolume.provider =  createProvider(vol)

            newVolume.fs = http_createFS(newVolume)     ' create fs access functions
            print "new filesystem volume info:";vol.location
            'printAA(newVolume)
            result.Push(newVolume)
        endif
      endif
    next
    m.task.activeVolumes = result
    return result
end function

function HttpFS_GetSearchCapabilities() as string
    print "HttpFS_GetSearchCapabilities"
    ' we cant search for anything yet
    return ""
end function

function http_createFS(volume)
    this = create_generic_FS(volume)
    this.GetDirectoryListing = httpFS_GetDirectoryListing
    this.GetSearchCapabilities = HttpFS_GetSearchCapabilities

    ' let us store reference to a componentController to reduece rendezvous
    gthis = GetGlobalAA()
    this.componentController = gthis.top.GetScene().componentController
    this.UpdateProgress = service_UpdateProgress
    this.GetProgressLabel = service_GetProgressLabel
    'this.Cancel = usb_Cancel
    return this
end function

Function HttpFS_GetUrl(url as string) as object
' Create a MessagePort to get url results
    urlMsgPort = CreateObject("roMessagePort")

    urlObject = CreateObject("roUrlTransfer")
    urlObject.SetUrl(url)
    urlObject.SetPort(urlMsgPort)
    urlObject.AsyncGetToString()
    while true
        msg = Wait(2000,urlMsgPort)
        print "HttpFS_GetUrl:got msg type="; type(msg)
        if type(msg) = "Invalid" then
            return invalid
        endif
        if type(msg) = "roUrlEvent" then
            'print "type of event="; msg.getint()
            'print "response code="; msg.getresponsecode()
            'print "response string="; msg.getstring()
            return msg
        endif
    end while
end function

Function HttpFS_GetUrlDir(url as string, silent as boolean) as object
    notsilent = not silent
    if notsilent
        print "HttpFS_GetUrlDir:";url
    endif
    a = CreateObject("roArray",10,true)
    ' fetch the directory contents
    urlval = m.GetUrl(url)
    if urlval <> invalid and (urlval.getresponsecode() = 200)
        ' discard anything with a trailing / (directory)
        dirstring = urlval.getstring()
        if notsilent and isVerbose() print "URLVAL=";dirstring
        start = 1
        if url.left(20) = "http://10.5.5.9:8080"
          ' special for gopro
          xml = CreateObject("roXMLElement")
          if xml.parse(dirstring)
             '   print "============================ XML =============================="
             'printXML(xml,1)
             bodylist = xml.getbody()
             'print "--------------------- xml.getbody/[1]/[0] ------------------------"

             body = bodylist[1]

             body2 = body.getbody()

             'printXML(body2,1)
             listlist = body2.div
             'print "##################### listlist ########################"
             'printXML(listlist,1)
             attr = listlist.getattributes()
             if attr.id = "dirlist"
               'print "FOUND DIRLIST+++++++++++++++++++++++++++++++++++++++++"
               table = listlist.table[0]
                'print "%%%%%%%%%%%%%%%%% TABLE %%%%%%%%%%%%%%%%%%%%%%"
                'printXML(table,1)
                trsxmllist = table.tbody

               for each tr in trsxmllist.tr
                'print "Processing :";
                'printxml(tr,1)

                icon = ""
                name = ""
                attr = tr.td[0].img.getattributes()
                if attr.class = "icon"
                    icon = attr.src
                    'print "FOund ico src=";icon
                endif
                attr = tr.td[1].a.getattributes()
                if attr.class = "link"
                    name = attr.href
                    'print "found href=";name
                endif
                if name <> ""
                    filename = name
                    if notsilent print "pushing filename=";filename
                    a.push(filename)
                endif
               end for
             endif
          endif
        else  ' plain old http dir
                ' this is usually not xml so we can't use xml parser
                ' try to extract items from http
              n = Instr(start,dirstring,"a href=")
                ' just look for all the hrefs values, maybe that will work
              while (n)
                  n = n + 8 ' skip the dbl quote
                  j = Instr(n,dirstring,chr(34))   ' find the next quote
                  filename = mid(dirstring,n,j-n)
                  start = j + 1
                  if notsilent print "processing filename="; filename
                  ' make sure first character is alpha-numeric
                  firstchar = asc(lcase(left(filename,1)))
                  if ((firstchar >= asc("0") and firstchar <= asc("9")) or (firstchar >= asc("a") and firstchar <= asc("z")) or (firstchar = asc("%")))
                     'print "legal fname="; filename
                     a.Push(filename)
                  endif
                  n = Instr(start,dirstring,"a href=")
              end while
        endif
    else
        if urlval <> invalid
            if notsilent print "HttpFS_GetUrlDir bad response code:";urlval.getresponsecode()
        else
            if not silent print "HttpFS_GetUrlDir got Invalid"
       endif
    endif
    ' stop
    return a
end function

function httpFS_GetDirectoryListing(objID as string, dlnasearchStr = "") as object
    retValue = genericVol_defaultGetDirRetVal(objID)
    m.cancelListRequest = false

    mimeTypes = USB_GetMimeTypes()
    httpfs = httpfsptr()
    lVerbose = isVerbose()
    timer = CreateObject("roTimeSpan")
    m.browseInProgress = true
    print "httpFS_GetDirectoryListing(";objID;") search=";dlnasearchStr
    i = 0
    if objID="0"
        objID = m.provider.location
    endif
    thumbMaxW = 1280
    thumbMaxH = 768
    gifMAXsize = maxGifSize()
    trackNum = 0   ' used for playlist to enforce order of playing

    isPlaylist = false
    playlistpath = CreateObject("roPath", objID)
    pathparts = playlistpath.Split()
    if pathparts.extension <> invalid
        extension = pathparts.extension.mid(1)
        if extension = "m3u" or extension = "m3u8"
            isPlaylist = true
        endif
    endif

    ' used for finding thumbnails for videos
    thumbs = {}
    vids = false

    if isPlaylist
        urlval = httpfs.getUrl( playlistpath )
        if urlval <> invalid and (urlval.getresponsecode() = 200)
            text = urlval.getstring()
        else
            return retValue
        endif
        listing = processPlaylist(text)
        path = pathparts.parent
    else ' not playlist
    path = objID
    if dlnasearchStr = ""
        listing = httpfs.GetUrlDir(objID, false)
    else
        ' create a search string and call file
        listing = CreateObject("roList")
        if dlnasearchStr.instr("dc:filename contains ")>=0
            firstquote = dlnasearchStr.instr(20, quote())
            if firstquote>0
                secondquote=dlnasearchStr.instr(firstquote+1, quote())
                if secondquote>0
                    targetStr=dlnasearchStr.mid(firstquote+1,secondquote-firstquote-1)

                    regex = targetStr
                    print "regex=";regex
                    listing = httpfs.fs.FindRecurse(path, regex)
                endif
            endif
        endif
      endif 'dlnasearchstring
    endif 'isPlaylist
    print "For each c in listing sofar=";StrI(timer.TotalMilliseconds());" milliseconds"
    watchCount = 0
    totalMatches = listing.count()

    filesPerUpdate = int(maxUPNPRequest()*2)    ' 20 or 40

    ' Save reference to a spinner until listing isn't finished to reduce rendezvous when updating progress
    if m.componentController <> invalid
        currentView = m.componentController.currentView
        if currentView <> invalid
            m.spinner = currentView.FindNode("spinner")
        end if
    end if
    m.timespan = CreateObject("roTimespan")

    dim files[totalMatches]
    for each c in listing
        ' check for interrupt
        ' res = httpfs.d.poll()
        if m.cancelListRequest
            exit for
        endif
            myishttp = false
            if isPlaylist and ishttp(c)
                ' plain subdirectories/playlists are not allowed inside a playlist
                ftype = "file"
                myishttp = true
                cpath = CreateObject("roPath", c)
                if cpath = ""
                        print "ERROR empty cpath"
                        ftype = ""
                endif
                if lVerbose print "cpath=";cpath
            else
                cpath = path + "/" + c
                if lVerbose print "cpath=";cpath
                if c.right(1) = "/"
                    ftype = "directory"
                else
                    ftype = "file"
                endif
            endif

            if ftype="directory"
                ' filter system files
                if not usbSystemFile(c)
                    item = {}
                    item.title = c
                    item.ShortDescriptionLine1 = c
                    item.objectID = cpath
                    item.isMedia = 0
                    item.isPlaylist = false
                    files.push(item)
                endif
            else if ftype = "file"
                tpath = CreateObject("roPath","ext1:/"+ c)
                'print "c=";c
                'print "tpath:";tpath
                pathparts = tpath.Split()
                print "pathparts";pathparts
                extension = pathparts.extension.mid(1)
                if extension <> ""
                    if extension = "mpd"
                        mimetype = { type: 1, format: "dash", name: "dash" }
                    else
                        mimetype = mimeTypes["x_" + extension]
                    endif
                    if mimetype <> invalid
                      if myishttp
                        ' switch back to original path specification
                        cpath = c
                      endif
                      if (mimetype.type = 0)
                        if isplaylist
                          ' we are already inside a playlist, this is a video
                          mimetype.type = 1
                        else
                          print "process potential playlist file:";cpath
                          urlval = httpfs.getUrl( cpath )
                          if urlval <> invalid and (urlval.getresponsecode() = 200)
                              text = urlval.getstring()
                              'print "text=";text
                              if text.left(7) = "#EXTM3U"
                                  mimetype.type = 1
                              else
                                  print c;" - regular playlist - create a folder entry"
                                  item = {}
                                  title = c
                                  id = cpath
                                  item.title = c
                                  item.ShortDescriptionLine1 = c
                                  item.objectID = id
                                  item.isMedia = 0
                                  item.isPlaylist = true
                                  files.push(item)
                              endif
                          endif
                        endif
                      endif
                      if mimetype.type <> 0
                        item = {}
                        item.title = pathparts.basename
                        item.ShortDescriptionLine1 = c
                        item.objectID = cpath
                        item.isMedia = mimetype.type
                        item.format = mimetype.format
                        item.formatname = mimetype.name
                        item.url = cpath
                        item.islive = false
                        item.ishttp = myishttp
                        item.size = -1
                        if isPlaylist
                            trackNum = trackNum + 1
                            item.track = intToZeroString(trackNum,4)
                        endif

                        itemok = true

                        debugformat = cpath
                        if mimetype.type = 1' video
                            item.description = c
                            vids = true
                        else if mimetype.type = 2' audio
                            item.description = c
                        else if mimetype.type = 3 ' picture
                          item.description = c
                          if mimetype.format="jpg"
                            thumbs.addreplace(item.title,cpath)
                          else if mimetype.format = "png"
                            thumbs.addreplace(item.title,cpath)
                          else if mimetype.format = "gif"
                          else
                                itemok = false
                          endif
                          if itemok
                            item.description = item.shortDescriptionLine1
                            item.TextOverlayUL = mimetype.name
                            item.TextOverlayBody = item.shortDescriptionLine1
                          endif 'itemok
                        end if ' mimetype
                        if itemok
                            ' for debugging
                            if lVerbose
                              prefix = "(" + item.format + ")"
                              if item.description <> invalid
                                item.description = prefix + item.description
                              else
                                item.description = prefix
                              end if
                              item.debugformat = debugformat + prefix ' printed out in gridscreen with info button
                            endif
                            files.push(item)
                          end if  ' itemok
                      endif 'playlist test
                    else ' unknown extension
                        print "httpfs: unknown file type1=";cpath
                    endif
                else ' no extension
                    print "httpfs: unknown file type2=";cpath
                end if
            end if
        i = i + 1
        watchCount = watchCount + 1
        if (totalmatches >= filesPerUpdate) and ((watchCount = filesPerUpdate) or (i = totalmatches))
            m.UpdateProgress(i/totalmatches)
            watchCount = 0
        endif
    end for
    ' Clearing reference to a spinner
    m.spinner = invalid

    m.browseInProgress = false
    if m.cancelListRequest
        print "List request cancel"
        return "cancel"
    endif
    ' post processing
    ' match thumbnail jpgs for video files
    if vids and not thumbs.isempty()
      for each f in files
        if f.ismedia = 1
            thumb = thumbs.lookup(f.title)
            if thumb <> invalid
                f.sdPosterURL = thumb
                f.hdPosterURL = thumb
            endif
        endif
      end for
    endif
    print "returning ";files.count();" files in ";StrI(timer.TotalMilliseconds());" milliseconds"
    retValue.files = files
    return retValue
end function
