' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

function NewSSDPController(port as Object) as Object
    this = {
        task: m.top
        port: port
        volumes: [] ' Actually MediaServers
        providers: {} ' MediaServers
        searchString: "" ' sent out via ssdp M-SEARCH

        ssdpAddress: "239.255.255.250"
        ssdpPort: 1900

        Init: SSDP_Init
        HandleEvent: SSDP_HandleEvent
    }
    this.Init()
    return this
end function

sub SSDP_Init()
    groupAddr = CreateObject("roSocketAddress")
    groupAddr.setAddress(m.ssdpAddress)
    groupAddr.setPort(m.ssdpPort)

    listenAddr = CreateObject("roSocketAddress")
    listenAddr.setAddress("0.0.0.0")
    listenAddr.setPort(m.ssdpPort)

    listen = CreateObject("roDatagramSocket")
    listen.setReuseAddr(true)
    listen.setAddress(listenAddr)
    listen.joinGroup(groupAddr)
    listen.setMessagePort(m.port)
    listen.notifyReadable(true)
    m.listen = listen

    searchSocket = CreateObject("roDatagramSocket")
    searchSocket.setMulticastLoop(false)
    searchSocket.setSendToAddress(groupAddr)
    searchSocket.setMulticastTTL(2)
    searchSocket.setMessagePort(m.port)
    searchSocket.notifyReadable(true)
    m.searchSocket = searchSocket

    print "Search socket multicastloop=";searchSocket.getMulticastLoop();" ttl=";searchSocket.getMulticastTTL(); " broadcast=";searchSocket.getBroadcast()

    ' presently we only respond to MediaServer search results and announcements
    ' might need to expand that to rootdevice
    ' this is case sensitive as some devices don't respond if MediaServer is mediaserver
    m.target = "urn:schemas-upnp-org:device:MediaServer:1"

    m.search           = ssdp_search
    m.pollSocket       = ssdp_pollsocket
    m.check            = ssdp_check
    m.checkSocket      = ssdp_checkSocket
    m.dumpAll          = ssdp_dumpAll
    m.dump             = ssdp_dump
    m.parse            = ssdp_parse
    m.request          = ssdp_request
    m.processProviders = ssdp_process_providers
    m.GetCurrentMSList = ssdp_GetCurrentMediaServerList
    m.getVolumeList    = ssdp_GetCurrentMediaServerList
    m.clearServerList  = ssdpClearServers
end sub

sub SSDP_HandleEvent(msg as Object)
    if type(msg) = "roSocketEvent" then
        if m.check()
            m.processProviders()
            m.task.volumesChanged = true
        end if  
    else if type(msg) = "roSystemLogEvent" then             
        i = msg.GetInfo()
        if i.LogType = "http.error" or i.LogType = "http.connect"
            if i.LogType = "http.error"
                print "http.error!!!!!!!!!!!!!!!!!!!!!!!!>>>>>>>>>>>>>>>>>>>>>"
                print "Handle the roSystemLogEvents:"
                print "Code: ";i.HttpCode
                print "Status: ";i.Status
                print "URL : ";i.Url
                if  i.Status = "noroutetohost" or i.Status = "connectionrefused" then
                    if getNetworkingRequest() and getNetworkingRequestURL() = i.Url then
                        'setErrorRemovalOn()
                        setNetworkErrorOn()
                    end if
                else
                    if getNetworkingRequest()then
                        'isNetworkErrorOn()
                   end if
                end if
                print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"     
            end if
        end If
    else if type(msg) = "roSGNodeEvent"
        field = LCase(msg.getField())
        if field = "getdirectorylisting"
            request = msg.GetData()
            mediaServer = request.mediaserver
            for each volume in m.volumes
                if volume.usn = mediaServer.usn
                    volume.fs.getDirectoryListing(request.objId, request.searchStr)
                end if
            end for
        else if field = "getsearchcapabilities"
            request = msg.GetData()
            mediaServer = request.mediaserver
            for each volume in m.volumes
                if volume.usn = mediaServer.usn
                    volume.fs.getSearchCapabilities()
                    exit for
                end if
            end for
        end if
    end if
end sub

function ssdpptr()
    return GetGlobalAA().ssdpController
end function

function ssdpClearServers()
    for each usn in m.providers
        provider = m.providers[usn]
        provider.deleted = true
        provider.changed = true
    end for
    m.volumes = []
end function

function ssdp_search()
    searchString =                "M-SEARCH * HTTP/1.1"        + WinNL()
    searchString = searchString + "MX: 2"                      + WinNL()
    searchString = searchString + "ST: " + m.target + WinNL()
    searchString = searchString + "MAN: " + quotestr("ssdp:discover")         + WinNL()
    searchString = searchString + "HOST: 239.255.255.250:1900" + WinNL()
    'searchString = searchString + "Connection: close" + WinNL()
    searchString = searchString                                + WinNL()
    m.searchString = searchString

    ' send out 2 requests
    ' at boot up, this function is called twice - first 1 right away to start to get results
    ' and second one for reaping results, resulting in a total of 4 broadcasts
    m.request()
    sleep(5)
    m.request()
end function

function ssdp_pollsocket(s as object) as boolean
    ret = false
    while s.isReadable()
        response = s.receiveStr(1024)
        if response <> ""
            'fromAddr = socket.getReceivedFromAddress()
            'print "SSDP: recv from '"; fromAddr.getAddress(); "' search status:"; socket.status()'; ", response '"; response; "'"
             if m.parse(response)
                 ret = true
             endif
        endif
    end while
    return ret
end function

function ssdp_check() as Boolean
    ret1 = m.pollSocket(m.searchSocket)
    ret2 = m.pollSocket(m.listen)
    return ret1 or ret2
end function

function ssdp_checkSocket(name as String) as Boolean
    updated = false
    socket = m[name]
    if socket.isReadable()
        response = socket.receiveStr(1024)
        if response <> ""
            fromAddr = socket.getReceivedFromAddress()
            if fromAddr <> invalid
                print "SSDP: recv from '"; fromAddr.getAddress(); "' "; name; " status"; socket.status()'; ", response '"; response; "'"
            endif
            updated = m.parse(response)
        endif
    end if
    return updated
end function

function ssdp_dumpAll()
    for each usn in m.providers
        provider = m.providers[usn]
        m.dump(provider)
    end for
end function

function ssdp_dump(provider as Object)
    print "SSDP: Provider: "; provider.usn + " {";
    for each attr in provider
        val = provider[attr]
        tval = type(val)
        if tval="roDateTime"
            val = Stri(val.getYear()).trim()+"-"+stri(val.getMonth())+"-"+stri(val.getDayOfMonth())+" "+stri(val.getHours())+":"+stri(val.getMinutes())+":"+stri(val.getSeconds())
        end if
        print attr; ":"; val; ", ";
    end for
    print "}"
end function

function ssdp_parse(response as String) as Boolean
    'print "ENTER ssdp_parse!!!!!!!!!!!!!!!!!!!!!!!!!"
    updated = false
    isSearch = false
    deleteAll = false
    lines = response.tokenize(WinNL())              ' split response into separate lines
    operation = lines.RemoveHead()
    if operation<>invalid
        'print "SSDP:parse:";response
        serviceAttribute = invalid
        parts = operation.tokenize(" ")
        cp = parts.count()
        if cp=3
            if Ucase(parts[0])="HTTP/1.1" and parts[1]="200" and Ucase(parts[2])="OK"
                serviceAttribute = "ST"
            else if  Ucase(parts[0])="NOTIFY" and parts[1]="*" and Ucase(parts[2])="HTTP/1.1"
                serviceAttribute = "NT"
            else if Ucase(parts[0])="M-SEARCH" and parts[1]="*" and Ucase(parts[2])="HTTP/1.1"
                isSearch = true
            end if
            if serviceAttribute<>invalid
                fields = {}
                ' create name:value pairs
                ' whitespace not dealt with very well here
                for each line in lines
                    colonSep = line.instr(":")                      ' find the first colon
                    if colonsep > 0
                        name = line.left(colonsep)                       ' extract headername
                        spaceSep = line.instr(" ")
                        if (colonSep + 1 = spaceSep)
                            val = line.mid(colonSep+2)
                        else 
                            val = line.mid(colonSep+1)
                        end if
                        fields[name] = val
                    else
                        print "Colon not found-";line
                    end if
                end for

                service = fields[serviceAttribute]
                usn = fields.usn
                if service<>invalid and usn<>invalid
                    lowerservice = lcase(service)
                    foundservice = ""
                    if lowerservice = "roku:ecp"
                       '   print "is roku:ecp - ignored"
                       ' look for patterns in the result string
                    else
                        found = false
                        if lowerservice.instr(lcase(m.target)) >= 0
                            found = true
                            'print "SSDP found target:"; m.target; " in ";lowerservice
                            foundservice = m.target
                            searching = 0
                        else
                            'print "Failed to find target(";m.target;") in ";lowerservice
                        end if

                       if found
                            provider = m.providers[usn]
                            if provider=invalid
                                print "provider not known usn=";usn
                                ntsub = fields["NTS"]
				' make sure not saying byebye
                                if ntsub <> invalid and ntsub.instr("byebye")>0
                                    print "byebye from unknown provider usn:"usn
                                else
                                    ' require a location field to create a provider
                                    if fields.location <> invalid
                                        provider = createProvider(fields)
                                        m.providers[usn] = provider
                                        updated = true
                                    endif
				end if
                            else ' provider=invalid
                                if isVerbose() then print "provider known usn=";usn
                                ntsub = fields["NTS"]
                                if ntsub <> invalid and ntsub.instr("byebye")>0
                                    print "SAYING BYEBYE to ";usn
                                    provider = m.providers[usn]
                                    if provider <> invalid
                                        'm.providers.delete(usn)
                                        provider.deleted = true
                                        provider.changed = true
                                        updated = true
                                    endif
                                else
                                    for each attr in fields
                                        'print "SSDP: field "; attr; " old: "; provider[attr]; " new: "; fields[attr]
                                        if fields[attr]<>provider[attr] then
                                            if attr <> "DATE"
                                                print attr;" difference[";fields[attr];"] and [";provider[attr];"]"
                                                updated = true
                                                exit for
                                            endif
                                        endif
                                    end for
                                    if not updated
                                        ' is this provider complete?
                                        if provider.devicetype = invalid
                                            print "restart retrieval of devicetype"
                                            provider.new = true
                                            updated = true   ' start refetch
                                        endif
                                    endif
                                    if updated
                                        provider.append(fields)
                                        evaluateProvider(provider)
                                        print "provider updated with fields----------------------------"
                                        print "server=";provider.server
                                        print provider
                                    endif
                                endif'ntsub
                            end if 'provider=invalid
			    if provider <> invalid
                            	provider.timestamp = CreateObject("roDateTime")
                            	provider.servicename = foundservice
                            	if updated
                                    provider.changed = true
                            	else
                                    'print "SSDP: "; usn; " no change"
                            	end if
			    end if
                        else 'found = false
                         'print "no service found in :";lowerservice
                         'print "full response=";response
                            ' check to see if this is a rootdevice byebye
                            if lowerservice.instr("upnp:rootdevice")>0
                                ntsub = fields["NTS"]
                                if ntsub.instr("byebye")>0
                                    print "SAYING BYEBYE to ";usn
                                    provider = m.providers[usn]
                                    if provider <> invalid
                                        'm.providers.delete(usn)
                                        provider.deleted = true
                                        provider.changed = true
                                        updated = true
                                    endif
                                endif
                            endif'lowerservice
                       end if'found 
                    endif 'lowerservice
                else
                    if service=invalid print "SSDP: invalid service  no ";serviceAttribute;" header"
                    if usn=invalid print "SSDP: invalid usn:"
                    print response
                end if'if service<>invalid and usn<>invalid
            else
                if isSearch
                    'print "is Search - ignored"
                else
                    print "SSDP: wrong http operation:"; response
                endif
            end if
        else
            print "SSDP: wrong http parameters count=";cp
            print response
        end if
    else
        print "SSDP: empty response"
    end if
    'print "EXIT ssdp_parse: updated=";updated
    return updated
end function

function ssdp_request()
    m.searchSocket.sendStr(m.searchString)
    toAddr = m.searchSocket.getSendToAddress()
    print "SSDP: send to "; toAddr.getAddress(); " status"; m.searchSocket.status(); ", request '"; m.searchString; "'"
end function

function ssdp_process_providers()
    upnp=get_upnp()
    print "Processing Providers"
    for each usn in m.providers
        print "Checking provider:";usn
        provider = m.providers[usn]
        if provider<>invalid
            if provider.new then upnp.get(provider) : provider.new = false
            if provider.changed
              print "Processing updated provider:";usn
              if provider.deleted
                print "Deleting provider ";usn
                c = m.volumes.count()
                i = 0
                while i<c
                    if m.volumes[i].usn=provider.usn
                        m.volumes.delete(i)
                        exit while
                    endif
                    i = i + 1
                end while
                m.providers.delete(usn) ' remove it from the provider list
              else
                volume = {}
                volume.label = provider.friendlyName
                volume.posterUrl = provider.HDPosterUrl
                loc = locationRoot(provider.location)
                if loc = invalid then loc = provider.location
                volume.ShortDescriptionLine2 = loc
                volume.usn = usn
                volume.provider = provider
                volume.port = m.port
                volume.accessType = DLNAAccessType()       ' UPNP
                volume.fs = upnp_createFS(volume)

                ' replace or add it to the list of volumes
                i = 0
                c = m.volumes.count()
                while i<c and m.volumes[i].usn<>provider.usn
                    i = i + 1
                end while
                print "_________________PROVIDER-SERVICES_________________________"
                print volume.provider.services
                m.volumes[i] = volume
                provider.changed = false
              endif
            end if
        else
            print "Invalid provider:";usn
        end if
    end for

    'update list of active media servers
    m.task.activeVolumes = ValidMediaServers(m.volumes)
end function

function isMediaserver(deviceType as String) as Boolean
'invalid or mediaserver devicetype not found then false
if deviceType = invalid or InStr(1,   LCase(devicetype), LCase("MediaServer")) = 0 then
    return false
end if
return true
end function

function hasContentDirectory(services as Object) as Boolean
    if services = invalid or services.ContentDirectory = invalid then
        return false
    end if

    serviceTypeElements = services.ContentDirectory.getnamedelements("serviceType")
    if serviceTypeElements.IsEmpty() or serviceTypeElements[0] = invalid then
        print "NO Service type"
        return false
    end if
    sTypeSTR = serviceTypeElements[0].GetText()
    if sTypeSTR = invalid or inStr(1,  LCase(sTypeSTR), LCase("ContentDirectory")) = 0 then
        print " NO ContentDirectory"
        return false
    end if 
    return true
end function

function ValidMediaServers(volumes)
        print "enter: ValidMediaServers count=";volumes.count()
        time = CreateObject("roTimespan")
        ' print "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!ValidMediaServers";time.TotalMilliseconds()
        validVolumes = []
        for each v in volumes
           ' print ">!!!!!!!!!!!!!!!!!!!!!!!Check valid volume v:"
           ' print "ValidMediaServers1";time.TotalMilliseconds()
            provider = v.provider
            ' print "ValidMediaServers2";time.TotalMilliseconds()
            'print v
            'print "++++++++++++++++++++++++"
            'print  provider
            if provider.devicetype <> invalid and isMediaserver(provider.devicetype) and provider.services <> invalid then
                ' print "ValidMediaServers3";time.TotalMilliseconds()
                if hasContentDirectory(provider.services) then
                    ' print "Pushing valid volume v:";v
                    ' print "ValidMediaServers3";time.TotalMilliseconds()
                    validVolumes.push(v)
                    ' print "ValidMediaServers5";time.TotalMilliseconds()
                else
                    print "No content directory service"
                end if         
          ' print "<<<<<<<<<<<<<<<<<<<<<<<<<end  valid volume v:"
            else
                print "BAD mediaserver"
            end if
            ' print "ValidMediaServers6";time.TotalMilliseconds()
        next
        ' print "ValidMediaServers end!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";time.TotalMilliseconds()
        return validVolumes
end function

function ssdp_GetCurrentMediaServerList()
    return ValidMediaServers(m.volumes)
end function
