' Copyright (c) 2020 Roku, Inc. All rights reserved.

sub Init()
    m.poster = m.top.FindNode("poster")
    m.title = m.top.FindNode("title")

    m.top.ObserveFieldScoped("height", "OnHeightChaged")
    m.top.ObserveFieldScoped("width", "OnWidthChanged")
    m.top.ObserveFieldScoped("rowFocusPercent", "OnRowFocusPercentChanged")
end sub

sub OnRowFocusPercentChanged(event as Object)
    focus = event.getData()
    if focus > 0.9
        m.title.color = "0x000000"
        m.title.font = "font:SmallBoldSystemFont"
        m.poster.opacity = focus
    else
        m.title.color = "0xffffff"
        m.title.font = "font:SmallSystemFont"
        m.poster.opacity = focus
    end if
end sub

sub OnHeightChaged(event as Object)
    height = event.getData()
    if height <> invalid and height > 0
        m.poster.height = height
    end if
end sub

sub OnWidthChanged(event as Object)
    width = event.getData()
    if width <> invalid and width > 0
        m.poster.width = width
        m.title.width = width
    end if
end sub


sub itemContentChanged(event as Object)
    content = event.getData()
    if content <> invalid
        m.title.text = content.title
    end if
end sub
