' Copyright (c) 2019 Roku, Inc. All rights reserved.

sub init()
    m.poster = m.top.findNode("poster")
    m.info = m.top.findNode("info")
    m.albumInfo = m.info.findNode("albumInfo")
    m.titleInfo = m.info.findNode("titleInfo")
    m.artistInfo = m.info.findNode("artistInfo")
    m.releaseInfo = m.info.findNode("releaseInfo")
    m.playBar = m.top.findNode("playBar")
    m.trickPlayGroup = m.top.findNode("trickPlayGroup")
    m.buttons = m.top.findNode("buttons")
    m.posterLayout = m.top.findNode("posterLayout")

    m.top.ObserveFieldScoped("buttonContent", "OnButtonContentChanged")
    m.top.ObserveFieldScoped("content", "OnContentChanged")
end sub

sub OnButtonContentChanged(event as Object)
    contentCopy = event.getData()
    newContent = CreateObject("roSGNode", "ContentNode")
    for each buttonContent in contentCopy.GetChildren(-1, 0)
        rowContent = newContent.CreateChild("ContentNode")
        rowContent.AppendChild(buttonContent)
    end for
    m.buttons.content = newContent
    if m.top.jumpToItem > 0 then m.buttons.jumpToItem = m.top.jumpToItem
end sub

sub OnContentChanged(event as Object)
    content = event.GetData()
    if content <> invalid
        if content.hdPosterUrl <> invalid and content.hdPosterUrl.Len() > 0
            m.poster.uri = content.hdPosterUrl
        else
            m.poster.uri = ""
        end if

        if content.album <> invalid and content.album.Len() > 0
            m.albumInfo.Update({
                text : content.album
            })
        else if content.stationTitle <> invalid and content.stationTitle.Len() > 0
            m.albumInfo.Update({
                text : content.stationTitle
            })
        else
            m.albumInfo.Update({
                text: ""
            })
        end if

        if content.title <> invalid and content.title.Len() > 0
            m.titleInfo.Update({
                text : content.title
            })
        else
            m.titleInfo.Update({
                text: ""
            })
        end if

        if content.artists[0] <> invalid and content.artists[0].Len() > 0
            m.artistInfo.Update({
                text : "by " + content.artists[0]
            })
        else
            m.artistInfo.Update({
                text : ""
            })
        end if

        if content.releaseDate <> invalid and content.releaseDate.Len() > 0
            m.releaseInfo.Update({
                text : content.releaseDate
            })
        else
            m.releaseInfo.Update({
                text : ""
            })
        end if
        
        if (content.length <> invalid and content.length > 0)
            m.playBar.duration = content.length
        else
            m.playBar.duration = 0
        end if

        SGDEX_UpdateViewUI()
    end if
end sub

sub GetColor(event as Object)
    color = event.getData()
    m.backgroundColor.UnObserveFieldScoped("color")
    m.backgroundColor = invalid
    if color <> invalid
        m.top.GetScene().backgroundColor = color
    end if
end sub

' ************* Theme functions *************

sub SGDEX_SetTheme(theme as Object)
    SGDEX_setThemeFieldstoNode(m, {}, theme)

    themeAttributes = {}
    SGDEX_setThemeFieldstoNode(m, themeAttributes, theme)
end sub


function SGDEX_GetViewType() as String
    return "NowPlayingView"
end function

sub SGDEX_UpdateViewUI()
    buttonBar = m.top.getScene().buttonBar
    buttonBaralignment = buttonBar.alignment
    isButtonBarVisible = buttonBar.visible
    if isButtonBarVisible
        if buttonBarAlignment = "left"
            visibleSafeArea = 1280 - (buttonBar.findNode("backgroundRectangle").width + 256)
            newOffset = ((1280 - (buttonBar.findNode("backgroundRectangle").width + 128)) / 2)
            if m.poster <> invalid
                newPosterOffset = (newOffset - (m.poster.width / 2))
                newPosterX = buttonBar.findNode("backgroundRectangle").width + newPosterOffset - 80
                m.posterLayout.translation = [newPosterX , 115]
                m.playBar.translation = [newPosterX , 425]
            end if
            if m.trickPlayGroup <> invalid
                newTrickPlayX = buttonBar.findNode("backgroundRectangle").width + newOffset - 80
                m.trickPlayGroup.translation = [newTrickPlayX, 455]
            end if
            if m.albumInfo <> invalid
                m.albumInfo.width = visibleSafeArea
            end if
            if m.titleInfo <> invalid
                m.titleInfo.maxWidth = visibleSafeArea
            end if
            if m.artistInfo <> invalid
                m.artistInfo.width = visibleSafeArea
            end if
            if m.releaseInfo <> invalid
                m.releaseInfo.width = visibleSafeArea
            end if
        end if
    end if
end sub
