Function GetFilteringSettings() As Dynamic
    return RMPGetRegistryIntwithDefault("Mediatype","MediatypeFiltering", 0)
End Function
Function SetFilteringSettings(filtering) As Void
    RMPSetRegistryInteger("Mediatype", "MediatypeFiltering", filtering)
End Function

Function GetSortingSettings() As Dynamic
    return RMPGetRegistryIntwithDefault("Mediatype","MediatypeSorting", 0)
End Function
Function SetSortingSettings(sorting As Integer) As Void
    RMPSetRegistryInteger("Mediatype", "MediatypeSorting", sorting)
End Function

Function getContentDisplayFormatSetting() As integer
    return RMPGetRegistryIntwithDefault("RMP-preferences","ContentDisplayFormat", 0)
End Function
Function setContentDisplayFormatSetting(fmt As Integer) As Void
    RMPSetRegistryInteger("RMP-preferences", "ContentDisplayFormat", fmt)
End Function

Function GetSlideshowSpeed() As Integer
    return RMPGetRegistryIntwithDefault("SlideShow","SShowSpeed", 1)
End Function
Function SetSlideshowSpeed(speed As Integer) As Void
    RMPSetRegistryInteger("SlideShow", "SShowSpeed", speed)
End Function

Function GetSavedSubtitleMode() As string
    if isGlobalSubtitle()
        return CreateObject("roDeviceInfo").GetCaptionsMode()
    else
        subt% = RMPGetRegistryIntwithDefault("VideoSettings","Subtitle", 0)
        if subt% = 1 then
            return "On"
        end if
        return "Off"
    endif
End Function
Function SetSavedSubtitleMode(subtitle As string) As Void
    if isGlobalSubtitle()
        print "Ignored saving Subtitle Mode"
    else ' only used pre 6.0 or so
       subt% = 0
       if subtitle="On" then
           subt% = 1
       end if
       RMPSetRegistryInteger("VideoSettings", "Subtitle", subt%)
    endif
End Function

Function GetSShowShuffleSettings() As Dynamic
    return RMPGetRegistryBoolwithDefault("SlideShow","SShowSuffle", false)
End Function
Function SetSShowShuffleSettings(shuffle As Boolean) As Void
    RMPSetRegistryBool("SlideShow","SShowSuffle",shuffle)
End Function

Function GetPictureRepeatSettings() As Dynamic
    ' currently not setable, it is always true
    return true
End Function

Function GetSShowInfoSettings() As Dynamic
    return RMPGetRegistryBoolwithDefault("SlideShow","SShowInfo", false)
End Function
Function SetSShowInfoSettings(info As Boolean) As Void
    RMPSetRegistryBool("SlideShow","SShowInfo",info)
End Function

Function GetAudioShuffleSettings() As Dynamic
    return RMPGetRegistryBoolwithDefault("AudioPlayback","AudioShuffle",false)
End Function
Function SetAudioShuffleSettings(shuffle As Boolean) As Void
    RMPSetRegistryBool("AudioPlayback","AudioShuffle",shuffle)
End Function

Function GetAudioRepeatSettings() As Dynamic
    audiorepeat_default = isAudioOnly() and isUSBOnly()
    return RMPGetRegistryBoolwithDefault("AudioPlayback","AudioRepeat", audiorepeat_default)
End Function
Function SetAudioRepeatSettings(repeat As Boolean) As Void
    RMPSetRegistryBool("AudioPlayback","AudioRepeat",repeat)
End Function

Function GetVideoShuffleSettings() As Dynamic
    return RMPGetRegistryBoolwithDefault("VideoPlayback","VideoShuffle",false)
End Function
Function SetVideoShuffleSettings(shuffle As Boolean) As Void
    RMPSetRegistryBool("VideoPlayback","VideoShuffle",shuffle)
End Function

function getRegistrySection(section) as object
    return CreateObject("roRegistrySection", Config().GetFromGlobal("registryPrefix") + section)
end function

Function GetVideoRepeatSettings() As Dynamic
    return RMPGetRegistryBoolwithDefault("VideoPlayback","VideoRepeat", false)
End Function
Function SetVideoRepeatSettings(repeat As Boolean) As Void
    RMPSetRegistryBool("VideoPlayback","VideoRepeat", repeat)
End Function

Function GetVideoPlaylistModeSettings() as Dynamic
    return RMPGetRegistryBoolwithDefault("VideoPlayback", "VideoPlaylistMode", true)
End Function
Function SetVideoPlaylistModeSettings(playlistMode as Boolean) as Void
    RMPSetRegistryBool("VideoPlayback", "VideoPlaylistMode", playlistMode)
End Function

Function RMPGetRegistryString(section as string, item as string) As Dynamic
    sec = getRegistrySection(section)
    if sec.Exists(item)  then
        return sec.Read(item)
    endif
    return invalid
End Function
Function RMPSetRegistryString(section as string, item as string, val as string) as void
    sec = getRegistrySection(section)
    sec.Write(item, val)
    sec.Flush()
end function

function GetDLNAFavorite() as string
    fav = RMPGetRegistryString("RMP-preferences","DLNAFav")
    if fav = invalid
        fav = ""
    endif
    return fav
end function
function SaveDLNAFavorite(fav as string)
    RMPSetRegistryString("RMP-preferences","DLNAFav", fav)
end function

Function RMPGetRegistryInteger(section as string, item as string) As Dynamic
    sec = getRegistrySection(section)
    if sec.Exists(item)  then
        return strtoi(sec.Read(item))
    endif
    return invalid
End Function
Function RMPSetRegistryInteger(section as string, item as string, val as integer) as void
    sec = getRegistrySection(section)
    sec.Write(item, stri(val))
    sec.Flush()
end function

Function RMPGetRegistryBool(section as string, item as string) As Dynamic
    sec = getRegistrySection(section)
    if sec.Exists(item)  then
        s = sec.Read(item)
        if s = "1" then
            return true
        end if
        return false
    end if
    return invalid
End Function

Function RMPSetRegistryBool(section as string, item as string, enabled As Boolean) As Void
    print "RMPSetRegistryBool(",section,",",item,")=",enabled
    sec = getRegistrySection(section)
    s = "0"
    if enabled then
        s = "1"
    end if
    sec.Write(item, s)
    sec.Flush()
End Function

Function RMPGetRegistryBoolwithDefault(section as string, item as string, default as boolean) as boolean
    val = RMPGetRegistryBool(section, item)
    if val = invalid
        return default
    endif
    return val
end function

Function RMPGetRegistryIntwithDefault(section as string, item as string, default as integer) as integer
    val = RMPGetRegistryInteger(section, item)
    if val = invalid
        return default
    endif
    return val
end function

Function GetMTSelectionScreenDisabled() As Dynamic
    disabled = Config().IsTrue("audioOnly") ' set up default audioonly is disabled
    return RMPGetRegistryBoolwithDefault("RMP-preferences","disableMTSScreen", disabled)
End Function
Function SetMTSelectionScreenDisabled(enabled As Boolean) As Void
    RMPSetRegistryBool("RMP-preferences","disableMTSScreen",enabled)
End Function

Function GetAlbumArtFromWebDisabled() As Dynamic
    return RMPGetRegistryBoolwithDefault("RMP-preferences","AlbumArtFromWebDisabled", false)
End Function
Function SetAlbumArtFromWebDisabled(enabled As Boolean) As Void
    RMPSetRegistryBool("RMP-preferences","AlbumArtFromWebDisabled",enabled)
End Function

function SetRokuTestMediaEnabled(enabled as boolean) as void
    RMPSetRegistryBool("RMP-preferences","RokuTestMediaEnabled",enabled)
end function
function RokuTestMediaEnabled() as boolean
    return RMPGetRegistryBoolwithDefault("RMP-preferences","RokuTestMediaEnabled", false)
end function

function SetNPSEnabled(enabled as boolean) as void
    RMPSetRegistryBool("RMP-preferences","NPSEnabled",enabled)
end function
function NPSEnabled() as boolean
    return RMPGetRegistryBoolwithDefault("RMP-preferences","NPSEnabled", false)
end function

function SetDimensionCheckDisabled(enabled as boolean) as void
    RMPSetRegistryBool("RMP-preferences","DimensionCheckDisabled",enabled)
    m.DimensionCheckDisabled = enabled
end function
function GetDimensionCheckDisabled() as boolean
    return RMPGetRegistryBoolwithDefault("RMP-preferences","DimensionCheckDisabled", false)
end function

function SetAutorunDisabled(enabled as boolean) as void
    RMPSetRegistryBool("RMP-preferences","AutorunDisabled",enabled)
    m.AutorunDisabled = enabled
end function
function GetAutorunDisabled() as boolean
    return RMPGetRegistryBoolwithDefault("RMP-preferences","AutorunDisabled", false)
end function

Function GetScreensaverSetting() As Boolean
    return RMPGetRegistryBoolwithDefault("RMP-preferences","Screensaver", false)
End Function
Function SetScreensaverSetting(setting As Boolean) As Void
    RMPSetRegistryBool("RMP-preferences", "Screensaver", setting)
End Function

Function GetUserAgents() as object
    print "GetUserAgents"
    if Config().Get("userAgents") <> invalid
        return Config().Get("userAgents")
    endif
    s = RMPGetRegistryString("RMP-preferences","UserAgents")
    print "from registry"
    print s
    uas = {}
    if s = invalid
        return uas
    endif
    lines = s.Tokenize( Chr( 10 ) )
    state = 0
    key = ""
    val = ""
    for each line in lines
        if state=0
            key = line
            state = 1
        else
            val = line
            if key<>"" and val<>""
                uas[key] = val
            endif
            state = 0
        endif
    next
    print uas
    return uas
end function
Function SaveUserAgents()
    s = ""
    userAgents = Config().Get("userAgents")
    for each uaKey in userAgents
        v = userAgents[uaKey]
        if v <> ""
            s = s + uaKey + Chr(10) + v + Chr(10)
        endif
    next
    print "Saving UserAgents"
    print s
    RMPSetRegistryString("RMP-preferences","UserAgents",s)
end function


function GetGridRowsStyle() as Integer
    return RMPGetRegistryIntwithDefault("GridStyle", "GridStyleRows", 0)
end function
function SetGridRowsStyle(style as Integer)
    RMPSetRegistryInteger("GridStyle", "GridStyleRows", style)
end function
