' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

sub GetContent()
    'need to save localizer reference to m so GetLocalizedImage will work
    m.localizer = CreateObject("roLocalization")
    servers = VolumeSelection_GetValidMediaServers()
    if servers.Count() > 0
        failedLoading = false
        contentAA = {
            children: [{
                title: Tr("Select Media Device")
                children: servers
            }]
        }
        m.top.content.Update(contentAA, true)
    else
        failedLoading = true
    end if
    m.top.content.Update({failedLoading: failedLoading}, true)
end sub

function VolumeSelection_GetValidMediaServers() as Object
    ret = []
    scene = m.top.GetScene()
    ret.append(SortVolumes(UpdateValidVolumes(scene.usb.activeVolumes)))
    if useDLNA() then ret.append(SortVolumes(UpdateValidVolumes(scene.dlna.activeVolumes)))
    if useHTTPFS() then ret.append(SortVolumes(UpdateValidVolumes(scene.httpfs.activeVolumes)))
    return ret
end function

function UpdateValidVolumes(MediaServerList as Object) as Object
    result = []
    voltrans = m.voltrans
    if voltrans = invalid
        voltrans = {}
        m.voltrans = voltrans
        voltrans.USB_HDPosterURL = GetLocalizedImage("poster_usb_memory_fhd.png")
        voltrans.USB_FHDPosterURL = GetLocalizedImage("poster_usb_memory_fhd.png")
        voltrans.UPNP_HDPosterURL = GetLocalizedImage("poster_media device_fhd.png")
        voltrans.UPNP_FHDPosterURL = GetLocalizedImage("poster_media device_fhd.png")
        voltrans.MediaServer = tr("Media Server")
        voltrans.USBDrive = tr("USB Drive")
    end if
    for each v in MediaServerList
        label = ValidStr(v.label)
        v.shortDescriptionLine1 = label
        v.file = label
        v.title = label ' required for roListScreen
        ' override icon if available
        if v.accesstype <> USBAccessType()
            v.shortDescriptionLine2 = voltrans.MediaServer
            if v.posterUrl <> invalid 'NWM_IsValidURL(v.posterUrl) then
                v.HDPosterUrl = v.posterUrl
                v.FHDPosterUrl = v.posterUrl
            else
                v.HDPosterUrl = voltrans.UPNP_HDPosterURL
                v.FHDPosterUrl = voltrans.UPNP_FHDPosterURL
            end if
        else ' assume USB
            v.shortDescriptionLine2 = voltrans.USBDrive
            if v.posterUrl <> invalid
                v.HDPosterUrl = v.posterUrl
                v.FHDPosterUrl = v.posterUrl
            else
                v.HDPosterUrl = voltrans.USB_HDPosterURL
                v.FHDPosterUrl = voltrans.USB_FHDPosterURL
            endif
        end if

        if (v.title = "" or v.title = invalid) and v.usn <> invalid and v.usn <> ""
            v.title = v.usn
        end if

        if (v.shortDescriptionLine1 = "" or v.title = invalid ) and v.usn <> invalid and v.usn <> ""
        v.shortDescriptionLine1 = v.usn
        end if

        result.Push(v)
    end for
    return result
end function

function SortVolumes(arr as Object) as Object
    if arr <> invalid and (arr.count() > 0) then
        customSort(arr, sortingAscendingID()) 'getSorting()
    end if
    return arr
end function
