' ********** Copyright 2020 Roku Corp. All Rights Reserved. **********

sub GetContent()
    ' search for subtitles inside curr dir on usb
  
    if m.top.isUSBAccessType and not ishttp(m.top.content.streams[0].url)
        appendUSBSubtitles(m.top.content, "srt")
        appendUSBSubtitles(m.top.content, "vtt")
        if hasLocalBif()
            attachUSBBifFile(m.top.content)
        end if
    end if
    enable608subtitles(m.top.content)
    UserAgentHeader = Config().Get("UserAgentHeader")
    if UserAgentHeader <> ""
        m.top.content.HttpHeaders = ["user-agent: " + UserAgentHeader]
    end if
    m.top.content.Update({failedLoading: false}, true)
end sub

function usb_FileExists(path) as Boolean
    rofs = CreateObject("roFileSystem")
    if rofs.Exists(path)
        info = rofs.Stat(path)
        if info.type = "file"
            return true
        endif
    endif
    return false
end function

' Only enable this if global subtitle mode is on - it can be cpu intensive
' Also do not enable it if we've found some srt files as it confuses track selection
' Also don't allow it with mkv since the mkv may have embedded non 608 caption tracks
' and this 608 parser kills them
sub enable608subtitles(episode as object)
    srts = episode.SubTitleTracks
    if (getsubtitleMode() <> "Off") and hasMultipleSRTURLs() and episode.isDirectPlay
        if (episode.subtitleurl = invalid or episode.subtitleurl = "") and ((srts=invalid) or (srts.count() = 0)) and (episode.streamformat <> "mkv")
            e = {
                   ShowSubtitle: getsubtitlemode()
                   TrackName : "eia608/1"
                }
            episode.SubtitleConfig = e
        endif
    endif
end sub

sub appendUSBSubtitles(episode as object, extension as string)
    ' look for <filename>.<extension>
    srtSubtitleUrl = makePathWithExtention(episode.streams[0].url, extension)
    fs = CreateObject("roFileSystem")
    if hasMultipleSRTURLs() ' depends on firmware
        cpath = CreateObject("roPath",episode.streams[0].url)
        pathparts = cpath.Split()
        srts = []
        listing = CreateObject("roList")
        if pathparts <> invalid AND pathparts.basename <> invalid
            searchStr = deFang(pathparts.basename) + "\.[a-z]{2,3}\."+extension
            print "attachUSBSubtitles search=";searchStr

            listing = fs.Find(pathparts.parent, searchStr)
            for each entry in listing
                len = len(entry)
                rawlang = entry.mid(len-8,4)
                dot = instr(rawlang,".")
                lang = rawlang.mid(dot)
                e = {
                    Language : lang
                    TrackName : pathparts.parent+entry
                }
                srts.push(e)
            end for
            if usb_FileExists(srtSubtitleUrl) then
                print "closed caption srt file ";srtSubtitleUrl;" exists"
                e = {
                    Language : "und"
                    TrackName : srtSubtitleUrl
                }
                srts.push(e)
            endif

            if srts.count() > 0
                episode.SubtitleTracks = srts
            endif
        end if 'pathparts or pathparts.basename invalid
    else
        if usb_FileExists(srtSubtitleUrl) then
            print "closed caption srt file ";srtSubtitleUrl;" exists"
            episode.subtitleUrl = srtSubtitleUrl
        endif
    endif
end sub

sub attachUSBBifFile(episode as object)
    ' look for <filename>.bif
    bifName = makePathWithExtention(episode.streams[0].url, "bif")
    ' first look for simple .bif file
    if usb_FileExists(bifName) then
        print "Found bif file ";bifName
        episode.SDBifUrl = bifName
        episode.HDBifUrl = bifName
        episode.FHDBifUrl = bifName
    else
        ' try -SD/-HD/-FHD.bif
        basename = bifname.left(bifName.len()-4) ' remove .bif
        bifname = basename + "-SD.bif"
        if usb_FileExists(bifName) then
            episode.SDBifUrl = bifName
            print "Found sdbif file ";bifName
        endif
        bifname = basename + "-HD.bif"
        if usb_FileExists(bifName) then
            episode.HDBifUrl = bifName
            print "Found hdbif file ";bifName
        endif
        bifname = basename + "-FHD.bif"
        if usb_FileExists(bifName) then
            episode.FHDBifUrl = bifName
            print "Found fhdbif file ";bifName
        endif
    endif
end sub
