' ********** Copyright 2020 Roku Corp. All Rights Reserved. **********

sub GetContent()
    selectedItem = m.top.selectedItem
    contentList = m.top.contentList
    
    ' content list is not specified or empty?
    if contentList = invalid or contentList.GetChildCount() = 0
        ' assume loading failure and return
        m.top.content.Update({failedLoading: true}, true)
        return
    end if
    
    if contentList.GetChild(0).GetChild(0) <> invalid
        contentList = ConvertGridToListContent(contentList, true)
    end if

    if selectedItem = invalid
        ' selected item is not specified for some reason,
        ' assume first item from the list as a workaround
        
        ' contentList is never empty at this point, see above if-statements
        selectedItem = contentList.GetChild(0)
        itemIndex = 0
    else
        ' locate item in the list
        itemIndex = ObjectLocationInList(selectedItem.objectID, contentList.getChildren(-1, 0))
    end if
        
    filteredAA = FilteredList(contentList, itemIndex, selectedItem.type)
    if GetSShowShuffleSettings()
        newArray = RandomizeArray(filteredAA.flist.getChildren(-1, 0), filteredAA.sitem)
        filteredAA.flist = CreateObject("roSGNode", "ContentNode")
        filteredAA.flist.AppendChildren(newArray)
    end if

    for each child in filteredAA.flist.getChildren(-1, 0)
        ' channel uses some smaller posters on grid
        ' so we need to reset real poster url to hdPosterUrl field
        child.hdposterurl = child.url
    end for
    m.top.content.Update({
        jumpToItem: filteredAA.sitem
    },true)
    m.top.content.AppendChildren(filteredAA.flist.getChildren(-1,0))
    m.top.content.Update({failedLoading: false}, true)
end sub