' ********** Copyright 2020 Roku Corp. All Rights Reserved. **********

sub GetContent()
    selectedItem = m.top.selectedItem
    contentList = m.top.contentList
    if contentList.GetChild(0).GetChild(0) <> invalid
        contentList = ConvertGridToListContent(contentList, true)
    end if

    itemIndex = ObjectLocationInList(selectedItem.objectID, contentList.GetChildren(-1,0))
    filteredAA = FilteredList(contentList, itemIndex, selectedItem.type)

    audioContent = GetAudioContent(filteredAA.flist, itemIndex)
    if Config().Get("UserAgentHeader") <> ""
        for each item in audioContent.getChildren(-1, 0)
            item.HttpHeaders = ["user-agent: " + Config().Get("UserAgentHeader")]
        end for
    end if

    if selectedItem.HasField("needToFind") and (not selectedItem.needToFind)
        filteredAA.sitem = -1
    end if

    if audioContent.isModifiedContent = true
        m.top.content.Update({
            jumpToItem: 0
        },true)
    else if filteredAA.sitem >= 0
        m.top.content.Update({
            jumpToItem: filteredAA.sitem
        },true)
    end if
    
    m.top.content.AppendChildren(audioContent.GetChildren(-1,0))
   
    m.top.content.Update({failedLoading: false}, true)
end sub

' helper function to create set all correct fields for playback and npn
function GetAudioContent(content as Object, itemIndex as Integer) as  Object
    newContent = CreateObject("roSGNode", "ContentNode")
    items = []
   
    maxPlaylistSize = 1000
    isModifiedContent = false

    currentPlaylistSize = content.GetChildCount()
    
    if currentPlaylistSize > maxPlaylistSize
        isModifiedContent = true

        playlistSize = DefinePlaylistSize(currentPlaylistSize, itemIndex,  maxPlaylistSize)
        remainingSize = DefineRemainingSize(playlistSize, maxPlaylistSize)
        
        items.Append(GetPlaylistFromContent(content, playlistSize, itemIndex))
        
        if remainingSize
            items.Append(GetPlaylistFromContent(content, remainingSize, 0))
        end if   
    else
        items.Append(GetPlaylistFromContent(content))
    end if
  
    newContent.Update({
        children: items,
        isModifiedContent: isModifiedContent
    }, true)   

    return newContent
end function


function DefinePlaylistSize(currentPlaylistSize as Integer, itemIndex as Integer, maxPlaylistSize as Integer)
    playlistSize = currentPlaylistSize - itemIndex 
    if playlistSize > maxPlaylistSize then playlistSize = maxPlaylistSize
    return playlistSize
end function


function DefineRemainingSize(playlistSize as Integer, maxPlaylistSize as Integer)
    remainingSize = 0
    if playlistSize < maxPlaylistSize then remainingSize = maxPlaylistSize - playlistSize
    return remainingSize
end function


function GetPlaylistFromContent(content as Object, playlistSize = -1 as Integer, startIndex = 0 as Integer)
    items = []
    for each child in content.GetChildren(playlistSize, startIndex)
        child.RemoveField("isTriggered")
        ' this info is enough for starting playback correctly
        if child.hdPosterUrl.Instr("pkg:") > -1
            ' set correct stub poster for npn
            child.hdPosterUrl = GetLocalizedImage("npn_poster.png")
            child.fhdPosterUrl = GetLocalizedImage("npn_poster.png")
        end if
        items.Push(child)
    end for
    return items
end function
