function init() as void
    m.top.functionName = "launchLegacyChannel"
end function

function launchLegacyChannel()
        appMgr = CreateObject("roAppManager")
        print "ChannelID: " + m.top.channelID
        if appMgr.IsAppInstalled(m.top.channelID, "")
            LaunchChannel(m.top.channelID)
        else
            InstallChannel(m.top.channelID)
        endif
    end function

Function GetIPAddress() As String
    If m.IPAddress = invalid Then
        deviceInfo = CreateObject("roDeviceInfo")
        ipAddresses = deviceInfo.GetIPAddrs()
        For Each eth in ipAddresses
            If ipAddresses[eth] <> invalid
                m.EthernetInterface = eth
                m.IPAddress = ipAddresses[eth]
                Exit For
            End If
        Next
    End If
    Return m.IPAddress
End Function

Sub LaunchChannel(channelID As String)
    url = "http://" + GetIPAddress() + ":8060/launch/" + channelID
    PostUrlToString(url)
End Sub

Sub InstallChannel(channelID As String)
    url = "http://" + GetIPAddress() + ":8060/launch/11?contentID=" + channelID
    PostUrlToString(url)
End Sub

Function PostUrlToString(url As String) As Object    
    response = {
        ResponseCode:       0
        ResponseHeaders:    {}
        Response:           ""
    }

    http = CreateObject("roUrlTransfer")
    http.SetPort(CreateObject("roMessagePort"))
    http.SetUrl(url)
    http.SetRequest("POST")

    If http.AsyncPostFromString("") Then
        msg = Wait(3000, http.GetPort())
        If Type(msg) = "roUrlEvent" And msg.GetInt() = 1 Then
            response.Response = msg.GetString()
            response.ResponseHeaders = msg.GetResponseHeaders()
            response.ResponseHeadersArray = msg.GetResponseHeadersArray()
            response.ResponseCode = msg.GetResponseCode()
            
        Else If msg = invalid Then
            http.AsyncCancel()
            response.ResponseCode = -1
        End If
    End If
    Return response
End Function


