echo "Wifi P2P launcher"
# Starts P2P app outside of main app environment
FLAG=/tmp/p2p-start

unset HAS_REALTEK
DRIVER=$(cat /tmp/wlan-driver)
[ "$DRIVER" = "realtek" ] && HAS_REALTEK=1

trap "rm -f $FLAG" EXIT

while true
do
    if [ -f $FLAG ]; then
        LINE=$(cat $FLAG)
        echo "=== P2P-start $LINE..."
        rm -f $FLAG
        if [ $HAS_REALTEK ]; then
            # S64wifi will itself avoid double-start
            source /etc/init.d/S64wifi $LINE
            wait
        else
            if ! pidof bcmp2papp >/dev/null; then
                source /etc/init.d/S67p2p $LINE
                wait
            fi
        fi
    fi
    sleep 2
done
