-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

to "TextNode.bootstrap-error" apply
{
    x = 0,
    y = 0,
    wrapBounds = Vec2(1000, -1)
}

to ".scroll-container-mask" apply
{
    x = previous.x - 1,
    y = previous.y + 1,
    width = previous.width + 2,
    height = previous.height + 2,
    pivotMode = previous.pivotMode
}

to ".input-text-mask" apply
{
	width = parent.width,
	height = parent.height,
}

local toPreload =
{
    "https://m.media-amazon.com/images/G/01/blast/images/template/background/spinner_LR._CB513876595_.png",
    "https://m.media-amazon.com/images/G/01/blast/images/template/filter_bg._CB_.png",
    "https://m.media-amazon.com/images/G/01/blast/images/template/background/blast_background.png",
    "https://m.media-amazon.com/images/G/01/blast/images/buttons/button.png",
    "https://m.media-amazon.com/images/G/01/blast/images/buttons/button-focused.png",
    "https://m.media-amazon.com/images/G/01/blast/images/buttons/button-small.png",
    "https://m.media-amazon.com/images/G/01/blast/images/buttons/button-small-focused.png",
    "https://m.media-amazon.com/images/G/01/blast/images/item/starRating/v3/stars_4.png",
    "https://m.media-amazon.com/images/G/02/blast/images/item/starRating/v3/stars_4.png",
    "https://m.media-amazon.com/images/G/09/blast/images/item/starRating/v3/stars_4.png",
    "https://m.media-amazon.com/images/G/01/blast/images/item/starRating/v3/stars_4.5.png",
    "https://m.media-amazon.com/images/G/02/blast/images/item/starRating/v3/stars_4.5.png",
    "https://m.media-amazon.com/images/G/09/blast/images/item/starRating/v3/stars_4.5.png",
    "https://m.media-amazon.com/images/G/01/blast/images/item/starRating/v3/stars_5.png",
    "https://m.media-amazon.com/images/G/02/blast/images/item/starRating/v3/stars_5.png",
    "https://m.media-amazon.com/images/G/09/blast/images/item/starRating/v3/stars_5.png"
}

for _, url in ipairs(toPreload) do
    defineAsset({
        name = url,
        source = url,
        preload = true
    })
end

to ".itemListImageLinkBannerView.blast-ImageViewComponentImpl,\
    .itemListHeroImageView.blast-ImageViewComponentImpl,\
    .itemListTVImageView.blast-ImageViewComponentImpl,\
    .homePageImageLinkView.blast-ImageViewComponentImpl,\
    .itemListMovieImageView.blast-ImageViewComponentImpl,\
    .subCategoryView > .subCategoryGalleryImage,\
    .blast-PointerArrowViewComponentImpl > .background" apply
{
    alpha = 0
}

to ".itemListImageLinkBannerView.blast-ImageViewComponentImpl:loaded,\
    .itemListHeroImageView.blast-ImageViewComponentImpl:loaded,\
    .itemListTVImageView.blast-ImageViewComponentImpl:loaded,\
    .homePageImageLinkView.blast-ImageViewComponentImpl:loaded,\
    .itemListMovieImageView.blast-ImageViewComponentImpl:loaded,\
    .subCategoryView > .subCategoryGalleryImage:loaded,\
    .blast-PointerArrowViewComponentImpl > .background:loaded" apply
{
    alpha = OutQuad()
        :duration(500)
        :to(1)
}

declareVariable('spinnerWidth', PropertyTypes.INT, 48)
declareVariable('spinnerHeight', PropertyTypes.INT, 48)

declareVariable('spinnerScale', PropertyTypes.FLOAT, 1)

-- The special case:
-- 	.homeLoadingSpinnerContainer.invisible > ImageNode.spinner.spinning
-- Prevents the ServerSpinner from animating while hidden.
-- The reason for this is that when the animation ount reaches zero on the homepage
-- the renderer can go into a low-CPU usage mode. Without this, animation count
-- stays at 1
to "ImageNode.spinner, \
    .homeLoadingSpinnerContainer.invisible > ImageNode.spinner.spinning" apply
{
    source = "https://m.media-amazon.com/images/G/01/blast/images/template/background/spinner_LR._CB513876595_.png",
    width = getVariable('spinnerWidth'),
    height = getVariable('spinnerHeight'),
    pivotMode = PivotMode(Pivot.CENTER, Pivot.CENTER, Pivot.MIN),
    layer = 100,
    alpha = Linear()
        :duration(200)
        :to(0),
    rotation = Linear()
        :to(Vec4(0, 0, 0, 1))
        :duration(1)
        :delay(200)
}

-- Horizontal pagination spinner on 2D browse homepage can be covered by other nodes (e.g. synopsis), unlike default spinners to be on top of everything
to "ImageNode.horizontalPaginationSpinnerView" apply
{
    layer = 0
}

local numberOfSpins = 10^6

to "ImageNode.spinner.spinning" apply
{
    alpha = Linear()
        :duration(200)
        :to(1),
    rotation = Linear()
        :to(Vec4(-360 * numberOfSpins, 0, 0, 1))
        :from(Vec4(0, 0, 0, 1))
        :duration(2000 * numberOfSpins),
}

for i=0,10 do
    to (".layer-" .. i) apply
    {
        layer = i + 2,
        -- Setting `drawIndex` as well since Ignition relies on it to decide which node should receive mouse events
        -- when it's hovered on. This way, only nodes on the highest layer should receive those events.
        drawIndex = i + 1
    }
end

for i=1,18 do
	defineAsset({
		name = "border-" .. (i + 1) .. ".png",
		source = "https://m.media-amazon.com/images/G/01/blast/images/template/background/border-" .. (i+1) .. ".png",
		preload = true
	})

	to (".border-" .. i .. " ImageNode") apply
	{
		source = getAsset("border-" .. (i + 1) .. ".png"),
		sliceRect = Rect(i+1,i+1,i+1,i+1),
		alpha = 0
	}

	to (".border-" .. i .. " ImageNode:loaded") apply
	{
		alpha = 1
	}
end

-- Forcing `BlendMode.NORMAL` on some browse page item images to work around Ignition image blending issues.
-- https://issues.amazon.com/issues/IGN-1737
-- https://issues.amazon.com/issues/IGN-2690
to ".castItemList, .castBrowseImgOverlay, .genericItemListImageTV, .genericItemListImageCast, \
    .itemListTVImageViewForLive, .itemListMovieImageViewForLive" apply
{
    blendMode = BlendMode.NORMAL
}

-- Xray ids with the above bug
to ".musicTileImage, .portraitTileImage, .sceneTileImage, .sceneTileOverlay, .sceneTileContainer, .musicTileOverlay, \
    .portraitTileOverlay, .carouselMiniDetailsButtonVisible, .carouselMiniDetailsButtonHidden, \
    .xrayPersonQuickviewImage, .xrayMusicQuickviewImage, .photoGalleryItemOverlay, .photoGalleryItemImage" apply
{
    blendMode = BlendMode.NORMAL
}

-- Xray photo gallery creates a loading spinner behind the image. Normally the loading spinner will be hidden when the image loads
-- however because the default loading spinner is on such a high layer it doesn't hide behind the image when the image loads. To
-- get around this we will move only this spinner to a lower layer
to "ContainerNode > ImageNode.xrayPhotoGallerySpinnerView" apply
{
    layer = 0
}

-- Setting draw index on media player control buttons so Ignition correctly handles hover and click events on these nodes.
-- If this is not set, they will have the same draw index as the media player controller parent node, and that node might
-- capture the mouse hover event because it also handles it (to make the controls come up when you move the pointer to
-- the bottom of the screen during playback).
to ".mediaControllerBackButtonView, .mediaControllerRewindButtonView, .mediaControllerPlayButtonView, \
    .mediaControllerPauseButtonView, .mediaControllerForwardButtonView, .mediaControllerNextTitleButtonView, \
    .mediaControllerCCButtonView" apply
{
    drawIndex = 1
}

-- This animation 'softens' transition between titles on the item detail view on the
-- browse page. There can be a sizable delay when transitioning ~250ms.
-- This tween make the transition look less glitchy
to ".itemDetailLinkedView" apply
{
    alpha = Linear()
        :duration(200)
        :from(0)
        :to(1)
}

-- This animation 'softens' transition between titles on the mini details view on the
-- home page.This tweek make the transition look less glitchy
to ".itemDetailView > .synopsis" apply
{
    alpha = Linear()
        :duration(350)
        :from(0)
        :to(1)
}
to ".itemDetailView > .itemTitle" apply
{
    alpha = Linear()
        :duration(350)
        :from(0)
        :to(1)
}

to ".itemDetailView > .itemIconContainer" apply
{
    alpha = Linear()
        :duration(350)
        :from(0)
        :to(1)
}

to ".filterButton" apply
{
	drawIndex = 3
}

-- We need to ensure the metadata container and all its child elements are layered correctly on the homepage.
-- Layer is 8 to match the z-index in the json styles.
to ".metadataContainer, .metadataTemplate, .pageTitle, .pageTitle .actual-text, .itemTitle, \
    .itemTitle .actual-text, .itemIconContainer, .itemIconContainer .starRatingIcon, .itemDetailGenericText, \
    .itemDetailGenericText .actual-text, .itemIconContainer .blast-ContainerViewComponentImpl, \
    .itemIconContainer .blast-ContainerViewComponentImpl .actual-image, .homePageSynopsis, .homePageSynopsis .actual-text" apply
{
    layer = 2,
    drawIndex = 2
}

to ".blackCurtainContainer" apply
{
	interactivityMode = InteractivityFlag.SELECT_ON_MOUSE_CLICK + InteractivityFlag.MOUSE_HOVERABLE,
	drawIndex = 4
}

to ".blackCurtainContainer.invisible" apply
{
	interactivityMode = InteractivityFlag.NONE
}

to ".landingPageContainerView .fullPageBgImage" apply
{
	z = 0
}

-- Blocking node to hide main view while on background mode
to "ContainerNode.blocker" apply
{
    alpha = 0.0,
    layer = 99
}

to "ContainerNode.blocker.block" apply
{
    alpha = 1.0
}

to "ContainerNode.blocker.unblock" apply
{
    alpha = Linear()
        :duration(200)
        :to(0.0)
}

--IG01-TXT
--H+/xQj+llFqsVJHI5Xk9dlCJoqaLYlfX4iWoo+gf3RK0zhCCoP8uwb6klhUVBwlg7Nr0kxrRI5OCQKAFKw94o9yDeZ9y98mrrRxk+VY6Ly3SzHmisPn9Z7h3CMK4pan+xGHNg04GQXXXOtX1GdGyXsQ/Sv7cIcDJQ4wbiIZwDlovqwTSgkM4/UiqlZdzQ6CVj6QaQjRzj49Y2PePsU8+RK7zM3ILOsInUiek6f9DzJ4NtJ1UJFB+NHeYujZNaINhOlHYDjEng+xJsNNX8EwuPchSFAXONSOiBK1sXJWNcvcRK8Y3OxXATXESiWRD9H68tqllk4EsevJSTOIDiS3f0Q==:IG01-TXT
--IG01-TXT
--PGsERxfEOmikThSJvSaTLm9PQEfsHEYowNE2qo4rzoxs8KlzXNI2X5lN7vE8fRX5R6Uu0oMSJfPU+i+XfW741ht9QdBa7iW7LyBvbxhMUdGEGWPwB0mie6ZZ+cQb9csI6394nsW/YwRHuPL6UjhvhVN56X7Wqzk9dEf3OHL9dJsFjKed6SKpSQwanKBInV1iD2QuFkqo3jeCcly5zcbBSsT4zJtfVqpa7+B6w2fZpO7Ooqx0WztsFD31OCzyKuP4PQaEtIlgA7/pu31NHBvX5/7byLqmmkdberBSxrbkf/e/vDYWsLr+VtDw1jgWud9h6VIKo4d0kZPXvzgXkClqlg==:IG01-TXT
--IG01-TXT
--KLEb8/PFaSVqgAn6ir/s+5/E+XrETNpegXh/WprALemaZXnu4/BPMS90rQS/Ea3UTBg2cnreuL33lqDqYQHUp4P499wCFVYGuOREjF4MD7BvnZPvbCKS6rZNW77JUHceWX1rsBeznmASylPVRkl1pk2IcnqcxvWlZPp4HGfsztVZMthqxVsSJTD1L3C62yqT1nNihkR9D4HvnuPDPbdSbXTCA9aj6f9FKYZqpqj03BVfcBLo/D+Kave3nTvE19ZRkrZ0Cjunu/K6HiXbudOegxxEUdv73/czEEhTbKp/MSCDjbAe5ghh85U+CkWW9cusCQc7+2rkF/p/WEcqkuY+0w==:IG01-TXT
--IG01-TXT
--YkjWwHOyO+VzNv15NcfsHFn3hUtyqWzTuE4UpXPhZ49cJ4YWbXYo11eWMhgwqhiSWenbcnmQjTj3N30ZccdP2WUTm07VxztixRk/BpqeUxFJ/tS+u4bBxiCNkE55n5f0xD/3IL1ITaliQdJ4+q2TTgNEb30GjkcDb2gbfDXynrLZt+OHXYYf60Qu0ZR/RS2eJC7xwi8gxhcNqbbwWcHsNQyy/cCqP8kbl8vHq8ekhiCSXw9DhkTQC+kveBT+e71F0Ee7pIgv4y07moW3yA//SiJNl77Vio/VII5eqnpscTsOQM8Y4SbLPjuV7BMxmp73fAcxGamxPeqF3VbnVT6ZjA==:IG01-TXT