#!/bin/bash
###############################################################################
# Copyright Statement:                                                        #
#                                                                             #
#   This software/firmware and related documentation ("MediaTek Software")    #
# are protected under international and related jurisdictions'copyright laws  #
# as unpublished works. The information contained herein is confidential and  #
# proprietary to MediaTek Inc. Without the prior written permission of        #
# MediaTek Inc., any reproduction, modification, use or disclosure of         #
# MediaTek Software, and information contained herein, in whole or in part,   #
# shall be strictly prohibited.                                               #
# MediaTek Inc. Copyright (C) 2010. All rights reserved.                      #
#                                                                             #
#   BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND      #
# AGREES TO THE FOLLOWING:                                                    #
#                                                                             #
#   1)Any and all intellectual property rights (including without             #
# limitation, patent, copyright, and trade secrets) in and to this            #
# Software/firmware and related documentation ("MediaTek Software") shall     #
# remain the exclusive property of MediaTek Inc. Any and all intellectual     #
# property rights (including without limitation, patent, copyright, and       #
# trade secrets) in and to any modifications and derivatives to MediaTek      #
# Software, whoever made, shall also remain the exclusive property of         #
# MediaTek Inc.  Nothing herein shall be construed as any transfer of any     #
# title to any intellectual property right in MediaTek Software to Receiver.  #
#                                                                             #
#   2)This MediaTek Software Receiver received from MediaTek Inc. and/or its  #
# representatives is provided to Receiver on an "AS IS" basis only.           #
# MediaTek Inc. expressly disclaims all warranties, expressed or implied,     #
# including but not limited to any implied warranties of merchantability,     #
# non-infringement and fitness for a particular purpose and any warranties    #
# arising out of course of performance, course of dealing or usage of trade.  #
# MediaTek Inc. does not provide any warranty whatsoever with respect to the  #
# software of any third party which may be used by, incorporated in, or       #
# supplied with the MediaTek Software, and Receiver agrees to look only to    #
# such third parties for any warranty claim relating thereto.  Receiver       #
# expressly acknowledges that it is Receiver's sole responsibility to obtain  #
# from any third party all proper licenses contained in or delivered with     #
# MediaTek Software.  MediaTek is not responsible for any MediaTek Software   #
# releases made to Receiver's specifications or to conform to a particular    #
# standard or open forum.                                                     #
#                                                                             #
#   3)Receiver further acknowledge that Receiver may, either presently        #
# and/or in the future, instruct MediaTek Inc. to assist it in the            #
# development and the implementation, in accordance with Receiver's designs,  #
# of certain softwares relating to Receiver's product(s) (the "Services").    #
# Except as may be otherwise agreed to in writing, no warranties of any       #
# kind, whether express or implied, are given by MediaTek Inc. with respect   #
# to the Services provided, and the Services are provided on an "AS IS"       #
# basis. Receiver further acknowledges that the Services may contain errors   #
# that testing is important and it is solely responsible for fully testing    #
# the Services and/or derivatives thereof before they are used, sublicensed   #
# or distributed. Should there be any third party action brought against      #
# MediaTek Inc. arising out of or relating to the Services, Receiver agree    #
# to fully indemnify and hold MediaTek Inc. harmless.  If the parties         #
# mutually agree to enter into or continue a business relationship or other   #
# arrangement, the terms and conditions set forth herein shall remain         #
# effective and, unless explicitly stated otherwise, shall prevail in the     #
# event of a conflict in the terms in any agreements entered into between     #
# the parties.                                                                #
#                                                                             #
#   4)Receiver's sole and exclusive remedy and MediaTek Inc.'s entire and     #
# cumulative liability with respect to MediaTek Software released hereunder   #
# will be, at MediaTek Inc.'s sole discretion, to replace or revise the       #
# MediaTek Software at issue.                                                 #
#                                                                             #
#   5)The transaction contemplated hereunder shall be construed in            #
# accordance with the laws of Singapore, excluding its conflict of laws       #
# principles.  Any disputes, controversies or claims arising thereof and      #
# related thereto shall be settled via arbitration in Singapore, under the    #
# then current rules of the International Chamber of Commerce (ICC).  The     #
# arbitration shall be conducted in English. The awards of the arbitration    #
# shall be final and binding upon both parties and shall be entered and       #
# enforceable in any court of competent jurisdiction.                         #
###############################################################################

#UBIFS config

echo "# mount 3rd"

#
# mount filesystem
#
if [ ! -f /tmp/3rd_mounted ]; then
	if [ -f /etc/config/3rdrw_in_perm ]; then
        if [ -f /tmp/perm_mounted ]; then
            if [ -f /perm/3rd_rw.tgz ]; then             
                echo "Format /3rd_rw partition -- start"
                /basic/bin/mke2fs -t ext4 /dev/mmcblk0p12
                echo "Format /3rd_rw partition -- end"    
            else
                echo "/perm/3rd_rw.tgz NOT EXIST!"
            fi                
        else
            echo "/perm NOT MOUNTED yet!!!"        
        fi
    fi
    
    if [ -f /etc/config/dual_3rd ];then
        if  $ TIME mount -t ext4 /dev/mmcblk0p12 /.3rd; then
            rm -rf /.3rd/3rd
            if [ -f /.3rd/3rd2/expire ];then
                ln -sf /.3rd/3rd2 /.3rd/3rd
                if [ -f /.3rd/start_from_3rd1 ];then
                    rm /.3rd/start_from_3rd1
                fi
                touch /.3rd/start_from_3rd2
            else
                ln -sf /.3rd/3rd1 /.3rd/3rd
                if [ -f /.3rd/start_from_3rd2 ];then
                    rm /.3rd/start_from_3rd2
                fi
                touch /.3rd/start_from_3rd1
            fi
            touch /tmp/3rd_mounted
        else
            echo "error! 3rd partition can't be mounted!!!"
            touch /tmp/3rd_need_to_be_formatted
            exit -2
        fi
    else
        if  $TIME mount -t ext4 /dev/mmcblk0p12 /3rd; then
            touch /tmp/3rd_mounted
        else
            echo "error! 3rd partition can't be mounted!!!"
            touch /tmp/3rd_need_to_be_formatted
            exit -2
        fi
    fi
    touch /tmp/3rd_mounted
else
    echo "3rd partition is already mounted!!!"
fi


if [ ! -d /3rd_rw/nfxdiskcache ];then
    mkdir /3rd_rw/nfxdiskcache
fi
if [ ! -f /3rd/permission_cfg ];then
chown netflix:netflix /3rd/netflix -R
chown browser:browser /3rd/internet_browser -R
chown browser:browser /3rd/browser_engine -R
chown amazon:amazon /3rd/amazon -R
chown vudu:vudu /3rd/vudu -R
chown cobalt:cobalt /3rd/cobalt -R

if [ -d /3rd_rw/nfxdiskcache ];then
    chmod 770 /3rd_rw/nfxdiskcache
    chown netflix:netflix /3rd_rw/nfxdiskcache
fi

mkdir -p /3rd/cobalt
chown cobalt:cobalt /3rd/cobalt -R
chmod 770 /3rd/cobalt -R

mkdir -p /3rd/ignition_data
chown amazon:amazon /3rd/ignition_data -R
chmod 770 /3rd/ignition_data -R

mkdir -p /3rd/mpeg_dash
chown root:system /3rd/mpeg_dash -R
chmod 770 /3rd/mpeg_dash -R

mkdir -p /3rd/divx
chown root:system /3rd/divx -R
chmod 770 /3rd/divx -R

mkdir -p /3rd/dlna
chown root:system /3rd/dlna -R
chmod 770 /3rd/dlna -R

mkdir -p /3rd/tts
chown root:system /3rd/tts -R
chmod 770 /3rd/tts -R

mkdir -p /3rd/mss chown root:system /3rd/mss -R
chmod 770 /3rd/mss -R

mkdir -p /3rd/playreadypk chown root:system /3rd/playreadypk -R
chmod 770 /3rd/playreadypk -R

mkdir -p /3rd/playready
chown root:system /3rd/playready -R
chmod 770 /3rd/playready -R

mkdir -p /3rd/widevine
chown root:system /3rd/widevine -R
chmod 770 /3rd/widevine -R

mkdir -p /3rd/widevine_eme
chown root:system /3rd/widevine_eme -R
chmod 770 /3rd/widevine_eme -R

touch /3rd/permission_cfg
sync
fi
