#! /bin/sh
# usage:
# dhcpv6.sh eth0 ip
# dhcpv6.sh eth0 dns
# dhcpv6.sh eth0 ipdns
# dhcpv6.sh shutdown

kill -9 `cat /var/lib/dibbler/client.pid`
rm -rf /var/lib/dibbler/*

if test $1 = "shutdown"; then
exit
fi

rm -rf /tmp/tmpclient.conf

echo "log-mode short" > /tmp/tmpclient.conf
echo "log-level 8" >> /tmp/tmpclient.conf
echo " " >> /tmp/tmpclient.conf
if test $2 = "dns"; then
    echo "stateless" >> /tmp/tmpclient.conf
fi
echo "iface '$1'" >> /tmp/tmpclient.conf
echo "{" >> /tmp/tmpclient.conf

if test $2 = "ip"; then
    echo " ia" >> /tmp/tmpclient.conf
fi

if test $2 = "dns"; then
    echo " option dns-server" >> /tmp/tmpclient.conf
fi

if test $2 = "ipdns"; then
    echo " ia" >> /tmp/tmpclient.conf
    echo " option dns-server" >> /tmp/tmpclient.conf
fi

echo " option lifetime" >> /tmp/tmpclient.conf
echo "}" >> /tmp/tmpclient.conf

cp /tmp/tmpclient.conf /tmp/dibbler/client.conf

loop=1

while [ ! -e "/var/lib/dibbler/client.pid" ]
do
    if [ $loop -le 10 ]; then
    		/bin/dibbler-client run & 
        sleep 2
        loop=$(( $loop + 1 ))
    else
    	  break
    fi
done

exit 0
